/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.collector.plugin.transformer;

import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.extras.common.log.Logger;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.http.JiraUrl;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;

public class ForgedBootstrapBaseUrlProtectorFilter
extends AbstractHttpFilter {
    private static final String BASE_URL_PARAM = "currentBaseUrl";
    public static final String BASE_URL_ATTR = ForgedBootstrapBaseUrlProtectorFilter.class.getName() + ":baseUrl";

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String queryString = request.getQueryString();
        if (request.getParameterMap().containsKey(BASE_URL_PARAM)) {
            String requestURL = request.getRequestURL().append("?").append(queryString).toString();
            Logger.getInstance(((Object)((Object)this)).getClass()).error((Object)String.format("Suspicious request containing %s param: %s", BASE_URL_PARAM, requestURL));
            response.sendError(403);
            return;
        }
        String baseUrl = JiraUrl.constructBaseUrl((HttpServletRequest)request);
        request.setAttribute(BASE_URL_ATTR, (Object)baseUrl);
        String encodedParam = "currentBaseUrl=" + JiraUrlCodec.encode((String)baseUrl);
        final String newQuery = queryString != null ? queryString + "&" + encodedParam : encodedParam;
        HttpServletRequestWrapper requestWrapper = new HttpServletRequestWrapper(request){

            public String getQueryString() {
                return newQuery;
            }
        };
        filterChain.doFilter((ServletRequest)requestWrapper, (ServletResponse)response);
    }
}

