/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.collector.plugin.transformer;

import com.atlassian.extras.common.log.Logger;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.collector.plugin.components.Collector;
import com.atlassian.jira.collector.plugin.components.CollectorService;
import com.atlassian.jira.collector.plugin.components.Trigger;
import com.atlassian.jira.collector.plugin.transformer.ForgedBootstrapBaseUrlProtectorFilter;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.transformer.CharSequenceDownloadableResource;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Element;

public class CollectorTransformer
implements WebResourceTransformer {
    private final CollectorService collectorService;

    public CollectorTransformer(CollectorService collectorService) {
        this.collectorService = collectorService;
    }

    public DownloadableResource transform(Element element, ResourceLocation resourceLocation, String s, DownloadableResource downloadableResource) {
        HttpServletRequest request = ExecutingHttpRequest.get();
        if (request.getAttribute(ForgedBootstrapBaseUrlProtectorFilter.BASE_URL_ATTR) == null) {
            Logger.getInstance(this.getClass()).error((Object)"Unfiltered Issue Collector bootstrap.js request.");
        }
        String collectorId = request.getParameter("collectorId");
        ServiceOutcome<Collector> result = this.collectorService.getCollector(collectorId);
        return new JavascriptSubstitutionDownloadableResource((Collector)result.getReturnedValue(), downloadableResource);
    }

    static class JavascriptSubstitutionDownloadableResource
    extends CharSequenceDownloadableResource {
        private static final Pattern VARIABLE_PATTERN = Pattern.compile("@([a-zA-Z][a-zA-Z0-9_]*)");
        private final Map<String, String> params = new HashMap<String, String>();

        public JavascriptSubstitutionDownloadableResource(Collector collector, DownloadableResource originalResource) {
            super(originalResource);
            String shouldCollectFeedback = "false";
            String collectorId = "";
            String triggerText = "";
            String triggerPosition = "\"\"";
            if (collector != null) {
                shouldCollectFeedback = String.valueOf(collector.isRecordWebInfo());
                collectorId = collector.getId();
                triggerText = StringEscapeUtils.escapeJavaScript((String)collector.getTrigger().getText());
                triggerPosition = collector.getTrigger().getPosition().equals((Object)Trigger.Position.CUSTOM) ? collector.getTrigger().getCustomFunction() : "\"" + collector.getTrigger().getPosition().toString() + "\"";
            }
            this.params.put("shouldCollectFeedback", shouldCollectFeedback);
            this.params.put("collectorId", collectorId);
            this.params.put("triggerText", triggerText);
            this.params.put("triggerPosition", triggerPosition);
        }

        protected String transform(CharSequence input) {
            Matcher matcher = VARIABLE_PATTERN.matcher(input);
            int start = 0;
            StringBuilder out = null;
            while (matcher.find()) {
                if (out == null) {
                    out = new StringBuilder();
                }
                out.append(input.subSequence(start, matcher.start()));
                String token = matcher.group(1);
                String subst = this.params.get(token);
                if (subst != null) {
                    out.append(subst);
                } else {
                    out.append(matcher.group());
                }
                start = matcher.end();
            }
            if (out == null) {
                return input.toString();
            }
            out.append(input.subSequence(start, input.length()));
            return out.toString();
        }
    }
}

