/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.collector.plugin.rest;

import com.atlassian.core.util.FileSize;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.collector.plugin.components.Collector;
import com.atlassian.jira.collector.plugin.components.CollectorService;
import com.atlassian.jira.collector.plugin.rest.TemporaryAttachmentsMonitorLocator;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.attachment.TemporaryAttachment;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.XsrfCheckResult;
import com.atlassian.jira.security.xsrf.XsrfInvocationChecker;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.util.AttachmentUtils;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.web.action.issue.TemporaryAttachmentsMonitor;
import com.atlassian.plugins.rest.common.multipart.FilePart;
import com.atlassian.plugins.rest.common.multipart.MultipartFormParam;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import webwork.config.Configuration;

@Path(value="tempattachment")
@Produces(value={"application/json"})
@AnonymousAllowed
public class TemporaryAttachmentsResource {
    private static final Logger log = Logger.getLogger(TemporaryAttachmentsResource.class);
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    public static final long UNKNOWN_ISSUE_ID = -1L;
    private final JiraAuthenticationContext authContext;
    private final XsrfInvocationChecker xsrfChecker;
    private final XsrfTokenGenerator xsrfGenerator;
    private final CollectorService collectorService;
    private final JiraAuthenticationContext authenticationContext;
    private final TemplateRenderer templateRenderer;
    private final AttachmentManager attachmentManager;
    @Context
    private HttpServletRequest request;

    public TemporaryAttachmentsResource(JiraAuthenticationContext authContext, XsrfInvocationChecker xsrfChecker, XsrfTokenGenerator xsrfGenerator, CollectorService collectorService, JiraAuthenticationContext authenticationContext, TemplateRenderer templateRenderer, AttachmentManager attachmentManager) {
        this.authContext = authContext;
        this.xsrfChecker = xsrfChecker;
        this.xsrfGenerator = xsrfGenerator;
        this.collectorService = collectorService;
        this.authenticationContext = authenticationContext;
        this.templateRenderer = templateRenderer;
        this.attachmentManager = attachmentManager;
        log.setLevel(Level.INFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{collectorId}")
    @Consumes(value={"*/*"})
    public Response addTemporaryAttachment(@QueryParam(value="filename") String filename, @PathParam(value="collectorId") String collectorId, @QueryParam(value="size") Long size) {
        ServletInputStream inputStream;
        XsrfCheckResult xsrfCheckResult = this.xsrfChecker.checkWebRequestInvocation(this.request);
        if (xsrfCheckResult.isRequired() && !xsrfCheckResult.isValid()) {
            return this.createTokenError(this.xsrfGenerator.generateToken(this.request));
        }
        if (!this.attachmentManager.attachmentsEnabled()) {
            return TemporaryAttachmentsResource.createError(Response.Status.BAD_REQUEST, this.authContext.getI18nHelper().getText("attachment.service.error.attachments.disabled"));
        }
        ServiceOutcome<Collector> result = this.collectorService.getCollector(collectorId);
        Collector collector = (Collector)result.getReturnedValue();
        if (StringUtils.isBlank((String)filename) || collector == null || !collector.isEnabled()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
        }
        if ((size == null || size < 0L) && (size = Long.valueOf(this.request.getContentLength())) < 0L) {
            String message = this.authContext.getI18nHelper().getText("attachfile.error.io.size", filename);
            return TemporaryAttachmentsResource.createError(Response.Status.BAD_REQUEST, message);
        }
        String contentType = this.request.getContentType();
        if (StringUtils.isBlank((String)contentType)) {
            contentType = DEFAULT_CONTENT_TYPE;
        }
        try {
            inputStream = this.request.getInputStream();
        }
        catch (IOException e) {
            String message = this.authContext.getI18nHelper().getText("attachfile.error.io.error", filename, e.getMessage());
            return TemporaryAttachmentsResource.createError(Response.Status.INTERNAL_SERVER_ERROR, message);
        }
        TemporaryAttachmentsMonitor temporaryAttachmentsMonitor = TemporaryAttachmentsMonitorLocator.getAttachmentsMonitor(this.request, collector.getId());
        if (temporaryAttachmentsMonitor == null) {
            return Response.serverError().cacheControl(CacheControl.NO_CACHE).build();
        }
        try {
            TemporaryAttachment attach = this.createTemporaryAttachment(filename, contentType, (InputStream)inputStream);
            temporaryAttachmentsMonitor.add(attach);
            Response response = Response.status((Response.Status)Response.Status.CREATED).entity((Object)new GoodResult(attach.getId(), filename)).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
            return response;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    @POST
    @Path(value="multipart/{collectorId}")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/html"})
    public Response attachTemporaryFileViaForm(@PathParam(value="collectorId") String collectorId, @MultipartFormParam(value="screenshot") Collection<FilePart> fileParts) {
        ServiceOutcome<Collector> outcome = this.collectorService.getCollector(collectorId);
        if (outcome.getReturnedValue() == null || !((Collector)outcome.getReturnedValue()).isEnabled()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.NO_CACHE).build();
        }
        Collector collector = (Collector)outcome.getReturnedValue();
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        TemporaryAttachmentsMonitor temporaryAttachmentsMonitor = TemporaryAttachmentsMonitorLocator.getAttachmentsMonitor(this.request, collector.getId());
        if (temporaryAttachmentsMonitor == null) {
            return Response.serverError().cacheControl(CacheControl.NO_CACHE).build();
        }
        Map context = JiraVelocityUtils.createVelocityParams((JiraAuthenticationContext)this.authenticationContext);
        if (fileParts.size() != 1) {
            context.put("errorMsg", i18n.getText("collector.plugin.template.error.no.attachments"));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.renderTemplate("templates/rest/tempfilejson.vm", context)).cacheControl(CacheControl.NO_CACHE).build();
        }
        FilePart filePart = fileParts.iterator().next();
        try {
            int maxAttachmentSize = new Integer(Configuration.getString((String)"webwork.multipart.maxSize"));
            if (filePart.getInputStream().available() > maxAttachmentSize) {
                context.put("errorMsg", i18n.getText("collector.plugin.template.error.attachment.large", FileSize.format((long)maxAttachmentSize)));
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.renderTemplate("templates/rest/tempfilejson.vm", context)).cacheControl(CacheControl.NO_CACHE).build();
            }
            TemporaryAttachment temporaryAttachment = this.createTemporaryAttachment(filePart.getName(), filePart.getContentType(), filePart.getInputStream());
            temporaryAttachmentsMonitor.add(temporaryAttachment);
            context.put("temporaryAttachment", temporaryAttachment);
            return Response.ok((Object)this.renderTemplate("templates/rest/tempfilejson.vm", context)).cacheControl(CacheControl.NO_CACHE).build();
        }
        catch (IOException e) {
            return Response.serverError().cacheControl(CacheControl.NO_CACHE).build();
        }
    }

    private TemporaryAttachment createTemporaryAttachment(String fileName, String contentType, InputStream inputStream) {
        long uniqueId;
        File tempAttachmentFile;
        File tmpDir = AttachmentUtils.getTemporaryAttachmentDirectory();
        while ((tempAttachmentFile = new File(tmpDir, String.valueOf(uniqueId = this.getUUID()))).exists()) {
        }
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(tempAttachmentFile);
            IOUtils.copy((InputStream)inputStream, (OutputStream)output);
            output.close();
        }
        catch (IOException e) {
            IOUtils.closeQuietly(output);
            log.error((Object)"Error creating temporary attachment", (Throwable)e);
            return null;
        }
        return new TemporaryAttachment(Long.valueOf(uniqueId), Long.valueOf(-1L), tempAttachmentFile, fileName, contentType);
    }

    private long getUUID() {
        return Math.abs(UUID.randomUUID().getLeastSignificantBits());
    }

    private static Response createError(Response.Status status, ErrorCollection collection) {
        String message = (String)TemporaryAttachmentsResource.getFirstElement(collection.getErrorMessages());
        if (message == null) {
            message = (String)TemporaryAttachmentsResource.getFirstElement(collection.getErrors().values());
        }
        return TemporaryAttachmentsResource.createError(status, message);
    }

    private static Response createError(Response.Status status, String message) {
        return Response.status((Response.Status)status).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).entity((Object)new BadResult(message)).build();
    }

    private Response createTokenError(String newToken) {
        String message = this.authContext.getI18nHelper().getText("attachfile.xsrf.try.again");
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).entity((Object)new BadResult(message, newToken)).build();
    }

    private <T> T throwFourOhFour(ErrorCollection errorCollection) {
        throw new WebApplicationException(TemporaryAttachmentsResource.createError(Response.Status.NOT_FOUND, errorCollection));
    }

    private static <T> T getFirstElement(Collection<? extends T> values) {
        if (!values.isEmpty()) {
            return values.iterator().next();
        }
        return null;
    }

    private String renderTemplate(String templatePath, Map<String, Object> context) {
        StringWriter out = new StringWriter();
        try {
            this.templateRenderer.render(templatePath, context, (Writer)out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toString();
    }

    @XmlRootElement
    public static class BadResult {
        @XmlElement
        private String errorMessage;
        @XmlElement
        private String token;

        private BadResult() {
        }

        BadResult(String msg) {
            this(msg, null);
        }

        BadResult(String msg, String token) {
            this.errorMessage = msg;
            this.token = token;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BadResult badResult = (BadResult)o;
            if (this.errorMessage != null ? !this.errorMessage.equals(badResult.errorMessage) : badResult.errorMessage != null) {
                return false;
            }
            return !(this.token != null ? !this.token.equals(badResult.token) : badResult.token != null);
        }

        public int hashCode() {
            int result = this.errorMessage != null ? this.errorMessage.hashCode() : 0;
            result = 31 * result + (this.token != null ? this.token.hashCode() : 0);
            return result;
        }
    }

    @XmlRootElement
    public static class GoodResult {
        @XmlElement
        private String name;
        @XmlElement
        private String id;

        private GoodResult() {
        }

        GoodResult(long id, String name) {
            this.id = String.valueOf(id);
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GoodResult that = (GoodResult)o;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
                return false;
            }
            return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            return result;
        }
    }
}

