/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.collector.plugin.components;

public final class Trigger {
    public static final String OLD_CUSTOM_FUNCTION = "function(onclickHandler) {\n\t//Requires that jQuery is available! \n\tjQuery(\"#myCustomTrigger\").click(function(e) {\n\t\te.preventDefault();\n\t\tonclickHandler();\n\t});\n}";
    public static final String TRIGGER_CUSTOM_FUNCTION_TEMPLATE = "window.ATL_JQ_PAGE_PROPS =  {\n\t\"triggerFunction\": function(showCollectorDialog) {\n\t\t//Requires that jQuery is available! \n\t\tjQuery(\"#myCustomTrigger\").click(function(e) {\n\t\t\te.preventDefault();\n\t\t\tshowCollectorDialog();\n\t\t});\n\t}};";
    private final String text;
    private final Position position;
    private final String customFunction;

    public Trigger(String text, Position position, String customFunction) {
        this.text = text;
        this.position = position;
        this.customFunction = customFunction;
    }

    public String getText() {
        return this.text;
    }

    public Position getPosition() {
        return this.position;
    }

    public String getCustomFunction() {
        return this.customFunction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Trigger trigger = (Trigger)o;
        if (this.customFunction != null ? !this.customFunction.equals(trigger.customFunction) : trigger.customFunction != null) {
            return false;
        }
        if (this.position != trigger.position) {
            return false;
        }
        return this.text.equals(trigger.text);
    }

    public int hashCode() {
        int result = this.text.hashCode();
        result = 31 * result + this.position.hashCode();
        result = 31 * result + (this.customFunction != null ? this.customFunction.hashCode() : 0);
        return result;
    }

    public static enum Position {
        TOP,
        CUSTOM,
        SUBTLE,
        RIGHT,
        INVALID;


        public String getI18nKey() {
            return "collector.plugin.trigger.position." + this.toString();
        }
    }
}

