/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.collector.plugin.components;

import com.atlassian.jira.collector.plugin.components.Template;
import com.atlassian.jira.collector.plugin.components.TemplateStore;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class TemplateStoreImpl
implements TemplateStore {
    static final List<Template> templates = new ArrayList<Template>();

    @Override
    public List<Template> getTemplates() {
        return Collections.unmodifiableList(new ArrayList<Template>(templates));
    }

    @Override
    public Template getTemplate(String id) {
        Assertions.notNull((String)"id", (Object)id);
        for (Template template : templates) {
            if (!template.getId().equals(id)) continue;
            return template;
        }
        return null;
    }

    static {
        templates.add(new Template("feedback", "collector.plugin.template.got.feedback", "templates/collector/feedback.vm"));
        templates.add(new Template("raise-bug", "collector.plugin.template.bug.raise.bug", "templates/collector/raise-bug.vm"));
        templates.add(new Template("custom", "collector.plugin.template.custom", "templates/collector/custom.vm"));
    }
}

