/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.collector.plugin.components;

import com.atlassian.jira.collector.plugin.components.Collector;
import com.atlassian.jira.collector.plugin.components.ScriptletRenderer;
import com.atlassian.jira.collector.plugin.components.Trigger;
import com.atlassian.jira.collector.plugin.components.TriggerConfigurationJSONCache;
import com.atlassian.jira.collector.plugin.rest.model.TriggerConfiguration;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.plugins.rest.common.json.JaxbJsonMarshaller;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tuckey.web.filters.urlrewrite.utils.StringUtils;

@Component
public class ScriptletRendererImpl
implements ScriptletRenderer {
    private static final Logger log = Logger.getLogger(ScriptletRendererImpl.class);
    private static final String SRC_ATTR = "src=\"";
    private final WebResourceManager webResourceManager;
    private final TemplateRenderer templateRenderer;
    private final JiraAuthenticationContext authenticationContext;
    private final TriggerConfigurationJSONCache triggerConfigurationJSONCache;
    private final JaxbJsonMarshaller jaxbJsonMarshaller;
    public static final String SCRIPT_TEMPLATE = "<script type=\"text/javascript\" src=\"%s\"></script>";

    @Autowired
    public ScriptletRendererImpl(WebResourceManager webResourceManager, TemplateRenderer templateRenderer, JiraAuthenticationContext authenticationContext, TriggerConfigurationJSONCache triggerConfigurationJSONCache, JaxbJsonMarshaller jaxbJsonMarshaller) {
        this.webResourceManager = webResourceManager;
        this.templateRenderer = templateRenderer;
        this.authenticationContext = authenticationContext;
        this.triggerConfigurationJSONCache = triggerConfigurationJSONCache;
        this.jaxbJsonMarshaller = jaxbJsonMarshaller;
    }

    @Override
    public String render(Collector collector) {
        return this.renderTemplate(collector, "templates/rest/scriptlet-source.vm", "issuecollector");
    }

    @Override
    public String renderJavascript(Collector collector) {
        return this.renderTemplate(collector, "templates/rest/scriptlet-source-javascript.vm", "issuecollector-embededjs");
    }

    @Override
    public String renderCleanBootstrapLink() {
        String resourceTag = this.webResourceManager.getResourceTags("com.atlassian.jira.collector.plugin.jira-issue-collector-plugin:issuecollector-embededjs", UrlMode.ABSOLUTE);
        if (resourceTag.contains(SRC_ATTR)) {
            resourceTag = resourceTag.substring(resourceTag.indexOf(SRC_ATTR) + SRC_ATTR.length(), resourceTag.lastIndexOf("\""));
        }
        return resourceTag;
    }

    @Override
    public String renderConfigurationBootstrap(Collector collector) {
        TriggerConfiguration triggerConfiguration = this.triggerConfigurationJSONCache.getTriggerConfiguration(collector.getId());
        if (triggerConfiguration == null) {
            return null;
        }
        StringBuilder scriptSrc = new StringBuilder();
        scriptSrc.append("typeof ATL_JQ_CONFIGS != 'undefined' || ( ATL_JQ_CONFIGS = {} );\n");
        scriptSrc.append("ATL_JQ_CONFIGS['").append(collector.getId()).append("'] = ").append(this.jaxbJsonMarshaller.marshal((Object)triggerConfiguration)).append(";\n");
        return scriptSrc.toString();
    }

    private String renderTemplate(Collector collector, String template, String resource) {
        StringWriter out = new StringWriter();
        Map context = JiraVelocityUtils.createVelocityParams((JiraAuthenticationContext)this.authenticationContext);
        context.put("triggerTextHtml", StringEscapeUtils.escapeJavaScript((String)collector.getTrigger().getText()));
        if (collector.getTrigger().getPosition().equals((Object)Trigger.Position.CUSTOM) && collector.getTrigger().getPosition().equals((Object)Trigger.Position.CUSTOM) && StringUtils.isBlank((String)collector.getTrigger().getCustomFunction())) {
            context.put("customFunctionHtml", "window.ATL_JQ_PAGE_PROPS =  {\n\t\"triggerFunction\": function(showCollectorDialog) {\n\t\t//Requires that jQuery is available! \n\t\tjQuery(\"#myCustomTrigger\").click(function(e) {\n\t\t\te.preventDefault();\n\t\t\tshowCollectorDialog();\n\t\t});\n\t}};");
        }
        String resourceTag = this.webResourceManager.getResourceTags(String.format("com.atlassian.jira.collector.plugin.jira-issue-collector-plugin:%s", resource), UrlMode.ABSOLUTE);
        try {
            Document doc = Jsoup.parse(resourceTag, "", Parser.xmlParser());
            StringBuilder accumulator = new StringBuilder();
            Elements elements = doc.getElementsByTag("script");
            for (Element e : elements) {
                String resourceUrl = new URIBuilder(e.attr("src")).setParameter("collectorId", collector.getId()).toString();
                accumulator.append(String.format(SCRIPT_TEMPLATE, resourceUrl));
                context.put("bootstrapUrlAsHtml", resourceUrl);
            }
            context.put("bootstrapHtml", accumulator);
            this.templateRenderer.render(template, context, (Writer)out);
        }
        catch (Exception e) {
            log.error((Object)"Unknown error rendering template scriptlet-source.vm", (Throwable)e);
            return "Error rendering script!";
        }
        return out.toString();
    }
}

