/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.collector.plugin.components;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.collector.plugin.components.Collector;
import com.atlassian.jira.collector.plugin.events.IssueCollectorCreatedEvent;
import com.atlassian.jira.collector.plugin.events.IssueCollectorDeletedEvent;
import com.atlassian.jira.collector.plugin.events.IssueCollectorDisabledEvent;
import com.atlassian.jira.collector.plugin.events.IssueCollectorEditedEvent;
import com.atlassian.jira.collector.plugin.events.IssueCollectorEnabledEvent;
import com.atlassian.jira.collector.plugin.events.IssueCollectorIssueSubmittedEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueCollectorEventDispatcher {
    private final EventPublisher eventPublisher;

    @Autowired
    public IssueCollectorEventDispatcher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void collectorCreated(Collector collector) {
        this.eventPublisher.publish((Object)new IssueCollectorCreatedEvent(collector.getId(), collector.getTemplate().getId(), collector.isUseCredentials(), collector.isRecordWebInfo()));
    }

    public void collectorDeleted(Collector collector) {
        this.eventPublisher.publish((Object)new IssueCollectorDeletedEvent(collector.getId(), collector.getTemplate().getId(), collector.isUseCredentials(), collector.isRecordWebInfo()));
    }

    public void collectorEnabled(Collector collector) {
        this.eventPublisher.publish((Object)new IssueCollectorEnabledEvent(collector.getId(), collector.getTemplate().getId(), collector.isUseCredentials(), collector.isRecordWebInfo()));
    }

    public void collectorDisabled(Collector collector) {
        this.eventPublisher.publish((Object)new IssueCollectorDisabledEvent(collector.getId(), collector.getTemplate().getId(), collector.isUseCredentials(), collector.isRecordWebInfo()));
    }

    public void issueSubmitted(Collector collector) {
        this.eventPublisher.publish((Object)new IssueCollectorIssueSubmittedEvent(collector.getId(), collector.getTemplate().getId(), collector.isUseCredentials(), collector.isRecordWebInfo()));
    }

    public void collectorEdited(Collector collector) {
        this.eventPublisher.publish((Object)new IssueCollectorEditedEvent(collector.getId(), collector.getTemplate().getId(), collector.isUseCredentials(), collector.isRecordWebInfo()));
    }
}

