/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.collector.plugin.components;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.collector.plugin.components.CreateIssueValidator;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={CreateIssueValidator.class})
public class CreateIssueValidatorImpl
implements CreateIssueValidator {
    private final IssueService issueService;

    @Autowired
    public CreateIssueValidatorImpl(IssueService issueService) {
        this.issueService = issueService;
    }

    @Override
    public Either<ErrorCollection, Issue> createIssueIfValid(ApplicationUser reporter, IssueInputParameters issueParams) {
        IssueService.CreateValidationResult validationResult = this.issueService.validateCreate(reporter, issueParams);
        if (!validationResult.isValid()) {
            return Either.left((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)validationResult.getErrorCollection()));
        }
        IssueService.IssueResult issueResult = this.issueService.create(reporter, validationResult);
        if (!issueResult.isValid()) {
            return Either.left((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)issueResult.getErrorCollection()));
        }
        MutableIssue issue = issueResult.getIssue();
        return Either.right((Object)issue);
    }
}

