/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.collector.plugin.components;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.collector.plugin.components.Collector;
import com.atlassian.jira.collector.plugin.components.CollectorActivityHelper;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.query.Query;
import com.atlassian.query.order.SortOrder;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={CollectorActivityHelper.class})
public class CollectorActivityHelperImpl
implements CollectorActivityHelper {
    private static final Logger log = Logger.getLogger(CollectorActivityHelperImpl.class);
    private final SearchService searchService;

    @Autowired
    public CollectorActivityHelperImpl(SearchService searchService) {
        this.searchService = searchService;
    }

    @Override
    public List<Issue> getCollectorIssues(ApplicationUser loggedInUser, Collector collector, int limit) {
        try {
            PagerFilter pagerFilter = limit <= 0 ? PagerFilter.getUnlimitedFilter() : new PagerFilter(limit);
            SearchResults result = this.searchService.search(loggedInUser, this.getQuery(collector), pagerFilter);
            return ImmutableList.copyOf(result.getIssues());
        }
        catch (SearchException e) {
            log.error((Object)"Recent issues search exception occurred", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public int getAllCollectorIssuesCount(ApplicationUser loggedInUser, Collector collector) {
        try {
            return (int)this.searchService.searchCount(loggedInUser, this.getQuery(collector));
        }
        catch (SearchException e) {
            log.error((Object)"Recent issues search exception occurred", (Throwable)e);
            return 0;
        }
    }

    @Override
    public String getJql(ApplicationUser loggedInUser, Collector collector) {
        return this.searchService.getJqlString(this.getQuery(collector));
    }

    @Override
    public String getIssueNavigatorUrl(ApplicationUser loggedInUser, Collector collector) {
        return "/secure/IssueNavigator.jspa?reset=true" + this.searchService.getQueryString(loggedInUser, this.getQuery(collector)) + "&mode=hide";
    }

    @Override
    public List<Integer> getIssuesCreatedPerDay(ApplicationUser loggedInUser, Collector collector, int daysPast) {
        int realDaysPast = Math.abs(daysPast);
        Query query = JqlQueryBuilder.newClauseBuilder((Query)this.getQuery(collector)).and().createdAfter("-" + realDaysPast + "d").buildQuery();
        try {
            SearchResults result = this.searchService.search(loggedInUser, query, PagerFilter.getUnlimitedFilter());
            List issues = result.getIssues();
            int[] createdPerDay = this.getNormalizedSums(realDaysPast, issues);
            ArrayList<Integer> ret = new ArrayList<Integer>(createdPerDay.length);
            for (int sum : createdPerDay) {
                ret.add(sum);
            }
            return ret;
        }
        catch (SearchException e) {
            log.error((Object)("Error running search '" + query + "'"), (Throwable)e);
            return Collections.emptyList();
        }
    }

    int[] getNormalizedSums(int realDaysPast, List<Issue> issues) {
        int[] createdPerDay = new int[realDaysPast];
        LocalDate dateTime = new LocalDate();
        LocalDate start = dateTime.dayOfYear().addToCopy(-realDaysPast);
        int startDay = start.dayOfYear().get() + 1;
        for (Issue issue : issues) {
            LocalDate created = new LocalDate((Object)issue.getCreated());
            int dayOfYear = created.dayOfYear().get();
            int arrayIndex = dayOfYear - startDay;
            if (arrayIndex < 0) {
                arrayIndex = start.dayOfYear().getMaximumValue() + arrayIndex;
            }
            if (arrayIndex < 0 || arrayIndex >= realDaysPast) continue;
            int n = arrayIndex;
            createdPerDay[n] = createdPerDay[n] + 1;
        }
        return createdPerDay;
    }

    private Query getQuery(Collector collector) {
        return JqlQueryBuilder.newBuilder().where().project(new Long[]{collector.getProjectId()}).and().labels(new String[]{"collector-" + collector.getId()}).endWhere().orderBy().createdDate(SortOrder.DESC).buildQuery();
    }
}

