/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.collector.plugin.components;

import com.atlassian.jira.collector.plugin.components.Template;
import com.atlassian.jira.collector.plugin.components.Trigger;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public final class Collector {
    private final String id;
    private final String name;
    private final Long projectId;
    private final Long issueTypeId;
    private final String creator;
    private final String reporter;
    private final String description;
    private final Template template;
    private final boolean enabled;
    private final boolean recordWebInfo;
    private final String customMessage;
    private final String customTemplateTitle;
    private final boolean useCredentials;
    private final Trigger trigger;
    private final List<String> customTemplateFields = new ArrayList<String>();
    private String customTemplateLabels;

    private Collector(String id, String name, Long projectId, Long issueTypeId, String creator, String reporter, String description, Template template, boolean enabled, boolean recordWebInfo, boolean useCredentials, Trigger trigger, String customMessage, List<String> customTemplateFields, String customTemplateTitle, String customTemplateLabels) {
        this.id = id;
        this.recordWebInfo = recordWebInfo;
        this.customMessage = customMessage;
        this.customTemplateLabels = customTemplateLabels;
        this.customTemplateTitle = customTemplateTitle;
        this.name = (String)Assertions.notNull((String)"name", (Object)name);
        this.projectId = (Long)Assertions.notNull((String)"projectId", (Object)projectId);
        this.issueTypeId = (Long)Assertions.notNull((String)"issueTypeId", (Object)issueTypeId);
        this.creator = creator;
        this.reporter = (String)Assertions.notNull((String)"reporter", (Object)reporter);
        this.template = (Template)Assertions.notNull((String)"template", (Object)template);
        this.description = description;
        this.enabled = enabled;
        this.useCredentials = useCredentials;
        this.trigger = (Trigger)Assertions.notNull((String)"trigger", (Object)trigger);
        this.customTemplateFields.addAll(new LinkedHashSet<String>(customTemplateFields));
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public Long getIssueTypeId() {
        return this.issueTypeId;
    }

    public String getReporter() {
        return this.reporter;
    }

    public String getDescription() {
        return this.description;
    }

    public Template getTemplate() {
        return this.template;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isRecordWebInfo() {
        return this.recordWebInfo;
    }

    public boolean isUseCredentials() {
        return this.useCredentials;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public String getCustomMessage() {
        return this.customMessage;
    }

    public List<String> getCustomTemplateFields() {
        return this.customTemplateFields;
    }

    public String getCustomTemplateTitle() {
        return this.customTemplateTitle;
    }

    public String getCustomTemplateLabels() {
        return this.customTemplateLabels == null ? "" : this.customTemplateLabels;
    }

    public String getCreator() {
        return this.creator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Collector collector = (Collector)o;
        return !(this.id != null ? !this.id.equals(collector.id) : collector.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public static class Builder {
        private String id = null;
        private String name;
        private Long projectId;
        private Long issueTypeId;
        private String creator;
        private String reporter;
        private String description = null;
        private Template template = null;
        private boolean enabled = false;
        private boolean recordWebInfo = false;
        private boolean useCredentials = false;
        private Trigger trigger = null;
        private String customMessage;
        private List<String> customTemplateFields = new ArrayList<String>();
        private String customTemplateTitle;
        private String customTemplateLabels;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder collector(Collector collector) {
            this.id = collector.getId();
            this.name = collector.getName();
            this.projectId = collector.getProjectId();
            this.issueTypeId = collector.getIssueTypeId();
            this.creator = collector.getCreator();
            this.reporter = collector.getReporter();
            this.description = collector.getDescription();
            this.enabled = collector.isEnabled();
            this.recordWebInfo = collector.isRecordWebInfo();
            this.template = collector.getTemplate();
            this.useCredentials = collector.isUseCredentials();
            this.trigger = collector.getTrigger();
            this.customMessage = collector.getCustomMessage();
            this.customTemplateFields = new ArrayList<String>(collector.getCustomTemplateFields());
            this.customTemplateTitle = collector.getCustomTemplateTitle();
            this.customTemplateLabels = collector.getCustomTemplateLabels();
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder projectId(Long projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder issueTypeId(Long issueTypeId) {
            this.issueTypeId = issueTypeId;
            return this;
        }

        public Builder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public Builder reporter(String reporter) {
            this.reporter = reporter;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder template(Template template) {
            this.template = template;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder recoredWebInfo(boolean enabled) {
            this.recordWebInfo = enabled;
            return this;
        }

        public Builder useCredentials(boolean useCredentials) {
            this.useCredentials = useCredentials;
            return this;
        }

        public Builder customMessage(String customMessage) {
            this.customMessage = customMessage;
            return this;
        }

        public Builder customTemplateFields(List<String> customTemplateFields) {
            this.customTemplateFields.clear();
            this.customTemplateFields.addAll(customTemplateFields);
            return this;
        }

        public Builder trigger(Trigger trigger) {
            this.trigger = trigger;
            return this;
        }

        public Collector build() {
            return new Collector(this.id, this.name, this.projectId, this.issueTypeId, this.creator, this.reporter, this.description, this.template, this.enabled, this.recordWebInfo, this.useCredentials, this.trigger, this.customMessage, this.customTemplateFields, this.customTemplateTitle, this.customTemplateLabels);
        }

        public Builder customTemplateTitle(String customTemplateTitle) {
            this.customTemplateTitle = customTemplateTitle;
            return this;
        }

        public Builder customTemplateLabels(String customTemplateLabels) {
            this.customTemplateLabels = customTemplateLabels;
            return this;
        }
    }
}

