/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.inviteuser;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.user.UserApplicationHelper;
import com.atlassian.jira.event.inviteuser.EditOrSendMoreInvitationsEvent;
import com.atlassian.jira.event.inviteuser.InvitationEmailSentEvent;
import com.atlassian.jira.event.inviteuser.InvitationFormSubmittedEvent;
import com.atlassian.jira.event.inviteuser.InvitationSubmissionEvent;
import com.atlassian.jira.plugin.inviteuser.Invitation;
import com.atlassian.jira.plugin.inviteuser.InvitationService;
import com.atlassian.jira.plugin.inviteuser.util.EmailUtils;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.BrowserUtils;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.user.UserBrowser;
import com.atlassian.mail.MailFactory;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atlassian.webresource.api.assembler.RequiredResources;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class InviteUser
extends JiraWebActionSupport {
    private final InvitationService invitationService;
    private final ApplicationRoleManager roleManager;
    private final UserApplicationHelper applicationHelper;
    private final UserManager userManager;
    private String email;
    private String[] selectedApplications;
    private List<InvitationService.SendValidationResult> validAddresses;
    private List<InvitationService.SendValidationResult> invalidAddresses;
    private EventPublisher eventPublisher;
    private PageBuilderService pageBuilderService;

    public InviteUser(InvitationService invitationService, EventPublisher eventPublisher, PageBuilderService pageBuilderService, ApplicationRoleManager roleManager, UserApplicationHelper applicationHelper, UserManager userManager) {
        this.invitationService = invitationService;
        this.eventPublisher = eventPublisher;
        this.pageBuilderService = pageBuilderService;
        this.roleManager = roleManager;
        this.applicationHelper = applicationHelper;
        this.userManager = userManager;
        this.validAddresses = new ArrayList<InvitationService.SendValidationResult>();
        this.invalidAddresses = new ArrayList<InvitationService.SendValidationResult>();
    }

    public String doDefault() throws Exception {
        this.requireResources();
        if (!this.hasMailServer()) {
            return "nomailserver";
        }
        if (this.selectedApplications == null) {
            this.selectedApplications = (String[])this.roleManager.getDefaultApplicationKeys().stream().map(ApplicationKey::value).toArray(String[]::new);
        }
        return super.doDefault();
    }

    private RequiredResources requireResources() {
        return this.pageBuilderService.assembler().resources().requireWebResource("com.atlassian.jira.jira-invite-user-plugin:inviteuser-admin-resources");
    }

    protected void doValidation() {
        this.requireResources();
        if (!this.hasAnyErrors()) {
            LinkedHashSet<String> emailAddresses = new LinkedHashSet<String>(EmailUtils.splitMultipleAddresses(this.email));
            if (emailAddresses.size() == 0) {
                this.addError("email", InvitationService.BadEmail.BLANK.getInlineError(this.getLoggedInUser()));
            }
            this.eventPublisher.publish((Object)new InvitationFormSubmittedEvent(emailAddresses.size()));
            for (String email : emailAddresses) {
                InvitationService.SendValidationResult result = this.invitationService.validateSendInvitation(this.getLoggedInUser(), email, InvitationService.Expiry.ONE_WEEK, this.getApplicationKeys());
                this.eventPublisher.publish((Object)new InvitationSubmissionEvent(result));
                if (result.isValid()) {
                    this.validAddresses.add(result);
                    continue;
                }
                this.invalidAddresses.add(result);
            }
            if (this.validAddresses.size() == 0 && this.invalidAddresses.size() == 1) {
                this.addErrorCollection(this.invalidAddresses.get(0).getErrorCollection());
            }
            if (this.roleManager.rolesEnabled() && this.getApplicationKeys().isEmpty()) {
                this.addErrorMessage(this.getText("inviteuser.error.no.app.keys"));
            }
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() {
        this.requireResources();
        for (InvitationService.SendValidationResult validationResult : this.validAddresses) {
            Invitation invitation = this.invitationService.sendInvitation(validationResult);
            this.eventPublisher.publish((Object)new InvitationEmailSentEvent(invitation));
        }
        if (this.validAddresses.size() > 0 && this.invalidAddresses.size() == 0) {
            return this.getRedirect(UserBrowser.getActionUrl(Optional.empty(), Optional.of("userInvitedFlag")));
        }
        return "success";
    }

    public String doAgain() {
        this.requireResources();
        this.eventPublisher.publish((Object)new EditOrSendMoreInvitationsEvent());
        return "input";
    }

    public String getEmail() {
        return this.email;
    }

    public List<InvitationService.SendValidationResult> getValidAddresses() {
        return this.validAddresses;
    }

    public List<InvitationService.SendValidationResult> getInvalidAddresses() {
        return this.invalidAddresses;
    }

    public String getInvalidAddressesCommaSeparated() {
        return Joiner.on((String)", ").join((Iterable)Collections2.transform(this.invalidAddresses, (Function)new Function<InvitationService.SendValidationResult, String>(){

            public String apply(@Nullable InvitationService.SendValidationResult input) {
                return input.getEmailAddress();
            }
        }));
    }

    public String getResultMessageType() {
        String messageType = "success";
        if (this.invalidAddresses.size() > 0) {
            messageType = this.validAddresses.size() > 0 ? "warning" : "error";
        }
        return messageType;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setSelectedApplications(String[] selectedApplications) {
        this.selectedApplications = selectedApplications;
    }

    public static String getModifierKey() {
        return BrowserUtils.getModifierKey();
    }

    private boolean hasMailServer() {
        return MailFactory.getServerManager().getDefaultSMTPMailServer() != null;
    }

    public List<String> getEmailErrors() {
        if (StringUtils.isBlank((CharSequence)((CharSequence)this.getErrors().get("email")))) {
            return ImmutableList.of();
        }
        return ImmutableList.of(this.getErrors().get("email"));
    }

    public Set<ApplicationKey> getApplicationKeys() {
        return (Set)Optional.ofNullable(this.selectedApplications).map(selectedApplications -> (ImmutableSet)Arrays.stream(selectedApplications).filter(ApplicationKey::isValid).map(ApplicationKey::valueOf).collect(CollectorsUtil.toImmutableSet())).orElse(ImmutableSet.of());
    }

    public Collection<UserApplicationHelper.ApplicationSelection> getSelectableApplications() {
        if (this.roleManager.rolesEnabled()) {
            Optional<Long> directoryId = this.userManager.getDefaultCreateDirectory().map(Directory::getId);
            return this.applicationHelper.getApplicationsForSelection(this.getApplicationKeys(), directoryId);
        }
        return ImmutableSet.of();
    }
}

