/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.inviteuser;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.user.UserApplicationHelper;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.event.inviteuser.InvitationRedeemedEvent;
import com.atlassian.jira.event.inviteuser.InvitationSignupFailedEvent;
import com.atlassian.jira.event.inviteuser.InvitationSignupFormNotShownEvent;
import com.atlassian.jira.event.inviteuser.InvitationSignupFormShownEvent;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.plugin.inviteuser.Invitation;
import com.atlassian.jira.plugin.inviteuser.InvitationService;
import com.atlassian.jira.plugin.inviteuser.InvitationSignUpHook;
import com.atlassian.jira.plugin.inviteuser.InvitationSignUpHooks;
import com.atlassian.jira.plugin.inviteuser.util.EmailUtils;
import com.atlassian.jira.plugin.inviteuser.util.SneakyAutoLoginUtil;
import com.atlassian.jira.plugin.user.PasswordPolicyManager;
import com.atlassian.jira.plugin.user.WebErrorMessage;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.BrowserUtils;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import webwork.action.ServletActionContext;

public class InvitationSignUp
extends JiraWebActionSupport {
    private final InvitationService invitationService;
    private final UserManager userManager;
    private final UserService userService;
    private final UserUtil userUtil;
    private final InvitationSignUpHooks hooks;
    private final EventPublisher eventPublisher;
    private final PasswordPolicyManager passwordPolicyManager;
    private final UserApplicationHelper applicationHelper;
    private final ApplicationRoleManager roleManager;
    private InvitationService.RedeemValidationResult redeemableResult;
    private Invitation invitation;
    private String token;
    private String username;
    private String password;
    private String fullname;
    private final List<WebErrorMessage> passwordErrors = new ArrayList<WebErrorMessage>();
    private UserService.CreateUserValidationResult result;
    private final PageBuilderService pageBuilderService;

    public InvitationSignUp(InvitationService invitationService, UserManager userManager, UserService userService, UserUtil userUtil, InvitationSignUpHooks hooks, EventPublisher eventPublisher, PasswordPolicyManager passwordPolicyManager, UserApplicationHelper applicationHelper, ApplicationRoleManager roleManager, PageBuilderService pageBuilderService) {
        this.invitationService = invitationService;
        this.userManager = userManager;
        this.userService = userService;
        this.userUtil = userUtil;
        this.hooks = hooks;
        this.eventPublisher = eventPublisher;
        this.passwordPolicyManager = passwordPolicyManager;
        this.applicationHelper = applicationHelper;
        this.roleManager = roleManager;
        this.pageBuilderService = pageBuilderService;
    }

    public String doDefault() throws Exception {
        this.requireResources();
        if (this.token == null || this.getInvitation() == null) {
            this.addErrorMessage(this.getText("inviteuser.signup.error.notoken"));
            this.eventPublisher.publish((Object)new InvitationSignupFormNotShownEvent("notoken"));
            return "block";
        }
        this.redeemableResult = this.invitationService.validateRedeemInvitation(this.getInvitation());
        if (!this.redeemableResult.isValid()) {
            this.addErrorCollection(this.redeemableResult.getErrorCollection());
            this.eventPublisher.publish((Object)new InvitationSignupFormNotShownEvent(this.redeemableResult));
            return "block";
        }
        if (!this.noUserLoggedIn()) {
            this.eventPublisher.publish((Object)new InvitationSignupFormNotShownEvent("userloggedin"));
            return "block";
        }
        if (!this.validateSeats()) {
            this.addErrorMessage(this.getText("inviteuser.signup.error.limit.reached", this.getAdministratorContactLink()));
            this.eventPublisher.publish((Object)new InvitationSignupFormNotShownEvent("userlimitreached"));
            return "block";
        }
        if (!this.validateApplicationAccess()) {
            this.addErrorMessage(this.getText("inviteuser.signup.error.applicationaccess.upfront"));
            this.eventPublisher.publish((Object)new InvitationSignupFailedEvent("applicationaccess"));
            return "block";
        }
        for (InvitationSignUpHook hook : this.hooks.getHooks()) {
            InvitationSignUpHook.HookValidationResult result = hook.doDefault(this);
            if (!result.hasAnyErrors()) continue;
            this.addErrorCollection(result.getErrors());
            this.eventPublisher.publish((Object)new InvitationSignupFormNotShownEvent(result.getReason()));
            return "block";
        }
        String usernameFromEmail = InvitationSignUp.getUsernameFromEmail(this.getEmail());
        if (this.isValidUsername(usernameFromEmail)) {
            this.username = usernameFromEmail;
        }
        this.eventPublisher.publish((Object)new InvitationSignupFormShownEvent());
        return super.doDefault();
    }

    private void requireResources() {
        this.pageBuilderService.assembler().resources().requireWebResource("com.atlassian.jira.jira-invite-user-plugin:inviteuser-signup-resources");
    }

    protected void doValidation() {
        if (this.shouldDoDefault()) {
            return;
        }
        if (this.token == null || this.getInvitation() == null) {
            this.addErrorMessage(this.getText("inviteuser.signup.error.notoken"));
            this.eventPublisher.publish((Object)new InvitationSignupFormNotShownEvent("notoken"));
            return;
        }
        if (!this.noUserLoggedIn()) {
            this.addErrorMessage(this.getText("inviteuser.signup.error.already.logged.in"));
            this.eventPublisher.publish((Object)new InvitationSignupFormNotShownEvent("userloggedin"));
            return;
        }
        this.redeemableResult = this.invitationService.validateRedeemInvitation(this.getInvitation());
        if (!this.redeemableResult.isValid()) {
            this.addErrorCollection(this.redeemableResult.getErrorCollection());
            this.eventPublisher.publish((Object)new InvitationSignupFailedEvent(this.redeemableResult));
            return;
        }
        if (!this.validateSeats()) {
            this.addErrorMessage(this.getText("inviteuser.signup.error.limit.reached", this.getAdministratorContactLink()));
            this.eventPublisher.publish((Object)new InvitationSignupFailedEvent("userlimitreached"));
            return;
        }
        if (!this.validateApplicationAccess()) {
            this.addErrorMessage(this.getText("inviteuser.signup.error.applicationaccess.submit", this.getAdministratorContactLink()));
            this.eventPublisher.publish((Object)new InvitationSignupFailedEvent("applicationaccess"));
            return;
        }
        UserService.CreateUserRequest createUserRequest = UserService.CreateUserRequest.withUserDetails((ApplicationUser)this.getLoggedInUser(), (String)this.getUsername(), (String)this.getPassword(), (String)this.getEmail(), (String)this.getFullname()).passwordRequired().sendNotification(false).performPermissionCheck(false).sendUserSignupEvent();
        Set<ApplicationKey> applicationKeys = this.getApplicationKeys();
        if (applicationKeys.isEmpty()) {
            createUserRequest.requireDefaultApplicationAccess();
        } else {
            createUserRequest.withApplicationAccess(applicationKeys);
        }
        this.result = this.userService.validateCreateUser(createUserRequest);
        if (!this.result.isValid()) {
            this.addErrorCollection(this.result.getErrorCollection());
            this.passwordErrors.addAll(this.result.getPasswordErrors());
            this.eventPublisher.publish((Object)new InvitationSignupFailedEvent(this.result));
        }
        for (InvitationSignUpHook hook : this.hooks.getHooks()) {
            InvitationSignUpHook.HookValidationResult result = hook.doValidation(this);
            if (!result.hasAnyErrors()) continue;
            this.addErrorCollection(result.getErrors());
            this.eventPublisher.publish((Object)new InvitationSignupFailedEvent(result.getReason()));
        }
    }

    protected String doExecute() throws Exception {
        ApplicationUser user;
        if (this.shouldDoDefault()) {
            return this.doDefault();
        }
        try {
            user = this.userService.createUser(this.result);
        }
        catch (CreateException e) {
            this.log.error((Object)"Error creating user from invitation sign up", (Throwable)e);
            this.addErrorMessage(this.getText("inviteuser.signup.error.creating.user", this.getAdministratorContactLink()));
            this.requireResources();
            return "block";
        }
        String result = this.getResult();
        if ("success".equals(result)) {
            int redeemed = this.invitationService.redeemInvitation(this.redeemableResult);
            this.eventPublisher.publish((Object)new InvitationRedeemedEvent(this.redeemableResult.getInvitation(), redeemed));
            if (this.logUserIn(user)) {
                return "loggedin";
            }
        }
        return result;
    }

    private boolean logUserIn(ApplicationUser user) {
        return SneakyAutoLoginUtil.logUserIn(user, this.password, this.request, ServletActionContext.getResponse());
    }

    private boolean isValidUsername(String username) {
        UserService.CreateUsernameValidationResult result = this.userService.validateCreateUsername(this.getLoggedInUser(), username);
        return result.isValid();
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getEmail() {
        return this.getInvitation() != null ? this.getInvitation().getEmailAddress() : null;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @HtmlSafe
    public List<String> getPasswordErrors() {
        return Lists.transform(this.passwordErrors, (Function)new Function<WebErrorMessage, String>(){

            public String apply(WebErrorMessage error) {
                return error.getSnippet();
            }
        });
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public Invitation getInvitation() {
        if (this.invitation == null) {
            this.invitation = this.invitationService.getInvitationByToken(this.token);
        }
        return this.invitation;
    }

    public String getSenderName() {
        ApplicationUser sender = this.userManager.getUser(this.getInvitation().getSenderUsername());
        return sender == null ? null : sender.getDisplayName();
    }

    public String getModifierKey() {
        return BrowserUtils.getModifierKey();
    }

    private static String getUsernameFromEmail(String emailAddress) {
        return EmailUtils.getLocalPart(emailAddress);
    }

    private boolean shouldDoDefault() {
        return "GET".equals(this.request.getMethod());
    }

    private boolean noUserLoggedIn() {
        if (this.getLoggedInUser() != null) {
            this.addErrorMessage(this.getText("inviteuser.signup.error.already.logged.in"));
            return false;
        }
        return true;
    }

    private boolean validateSeats() {
        if (this.roleManager.rolesEnabled()) {
            Optional<Long> directoryId = this.userManager.getDefaultCreateDirectory().map(Directory::getId);
            return this.applicationHelper.validateApplicationKeys(directoryId, this.getApplicationKeys(), EnumSet.of(UserApplicationHelper.ValidationScope.SEATS)).isEmpty();
        }
        return this.userUtil.canActivateNumberOfUsers(1);
    }

    private boolean validateApplicationAccess() {
        if (this.roleManager.rolesEnabled()) {
            return this.applicationHelper.validateApplicationKeys(Optional.empty(), this.getApplicationKeys(), EnumSet.allOf(UserApplicationHelper.ValidationScope.class)).isEmpty();
        }
        return true;
    }

    private Set<ApplicationKey> getApplicationKeys() {
        return this.invitation.getApplicationKeys();
    }
}

