/*globals GH,console*/
require([
    'underscore',
    'jquery',
    'jira/inline-issue-create/util'
], function (
    _,
    $,
    Util
    ) {
    "use strict";

    function trace (name){
        var fullName = "iic.test." + name;
        JIRA.trace(fullName);
        console.info(fullName);
    }

    function traceAfter(object, method, event, callback){
        Util.after(object, method, function callTrace(){
            if(_.isFunction(callback)){
                callback.apply(this, arguments);
            }
            trace(event);
        });
    }

    function equal (actual, expected, message){
        if(actual === expected){
            console.debug("Passed: ", message);
        } else {
            throw message;
        }
    }

    function ok(truthy, message) {
        equal(truthy, true, message);
    }

    traceAfter(GH.PlanControls, "init", "controls.inited");
    traceAfter(GH.SprintView, "renderAllSprints", "render.all.sprints");
    traceAfter(GH.BacklogModel, "setData", "backlog.data.set");
    traceAfter(GH.BacklogView,  "_scrollToView", "scrolled.to.issue");
    traceAfter(GH.BacklogModel, "updateDataForSprint", "updated.data.for.sprint");

    traceAfter(GH.SprintBacklogView, "renderBacklog", "backlog.rendered");
    traceAfter(GH.SprintBacklogView, "updateBacklog", "backlog.updated");
    traceAfter(GH.RapidBoard.State, "setRapidViewId", "rapid.view.changed");

    traceAfter(GH.SprintView, "_renderSprintContent", "sprint.content.rendered", function checkRenderSprintContentArguments(result, sprintModel){
        ok(_.isBoolean(sprintModel.isActiveSprint()), "sprint should contain isActiveSprint property");
        ok(_.isNumber(sprintModel.getSprintData().id), "all sprints should contain id");
        trace("sprint.content.rendered."+sprintModel.getSprintData().id);
    });


    //unfortunately we have to defer those checks until JA is inited
    Util.after(GH.PlanControls, "init", function initPlanControls(){
        traceAfter(GH.PlanControls.quickfilters, "setActiveQuickFilters", "active.filters.set");
    });



    // "Called" tests

    window.iicTests = {};
    window.iicTestNames = [];

    function test(name, body) {
        window.iicTests[name] = function(){
            body();
            trace("testCase."+name);
        };
        window.iicTestNames.push(name);
    }

    function testAsync(name, body) {
        window.iicTests[name] = function () {
            var finishMethod = function () {
                trace("testCase." + name);
            };
            body(finishMethod);
        };
        window.iicTestNames.push(name);
    }

    test("testGetQuickFilters", function(){
        var result = GH.PlanControls.quickfilters.getQuickFilters();
        equal(result.length, 2, "There should be two filters");
        _.each(result, function(e){
            ok(_.isBoolean(e.isActive), "Filters should have `isActive` property");
            ok(_.isString(e.query), "Filters should have `query` property");
        });
    });

    test("testFutureSprintModels", function(){
        var result = GH.BacklogModel.getFutureSprintModels();
        equal(result.length, 3, "There should be 3 future sprints");

        _.each(result, function(e){
            ok(_.isObject(e.sprintData), "Model contains sprint data");
            ok(_.isNumber(e.sprintData.id), "Model contains numeric id");
            ok(_.isString(e.sprintData.name), "Model contains sprint's name");
        });
    });


    test("testGetRapidViewId", function(){
        var result = GH.RapidBoard.State.getRapidViewId();
        ok(_.isNumber(result), "getRapidViewId should return rapid view ID");
    });

    testAsync("testGetRapidView", function(done){
        GH.Ajax.get({
            url: '/rapidviewconfig/editmodel.json',
            data: { rapidViewId: GH.RapidBoard.State.getRapidViewId() }
        }, 'rapidBoardJQL').done(function onBoardJqlFetched(model) {
            ok(_.isString(model.filterConfig.query), "current filter config should be string");
            done();
        });
    });

    test("testGetBacklogModel2GetIssueList", function() {
        var issueList = GH.BacklogModel.getBacklogModel2().getIssueList();
        ok(_.isObject(issueList), "getBacklogModel2().getIssueList() should return issue list");
    });

});
