/*globals GH*/
define('jira/inline-issue-create/agile/widget-group', [
    'jira/inline-issue-create/agile/widget',
    'jira/inline-issue-create/agile/issue-type-dropdown',
    'jira/inline-issue-create/widget-group',
    'jquery',
    'jira/inline-issue-create/util'
], function(
    AgileWidget,
    AgileDropdown,
    WidgetGroup,
    $,
    Util
) {
    "use strict";

    return WidgetGroup.extend({
        initialize: function initialize() {
            WidgetGroup.prototype.initialize.apply(this, arguments);
            this.Widget = AgileWidget;
            this.boardJQL = undefined;
            this.filterJQLs = undefined;
            _.bindAll(this, "issueCreatedHandler", "addOverridesOnBeforeIssueCreated");
            this.on("widget:rendered", this.widgetRenderedHandler);
            this.widgetOptions.dropdownView = AgileDropdown;
        },
        widgetRenderedHandler: function widgetRenderedHandler(widget, trigger, container) {
            // it is not easy to find .ghx-backlog-container (which is proper backlog container)
            // as at this point it may be not attached to DOM so we have stick to .ghx-meta
            var parent = container.parent(".ghx-meta");
            parent.addClass("plan-inline-create-inside");
        },
        issueCreatedHandler: function issueCreatedHandler(issue, prefilledFields, widget) {
            var manager = this;
            widget.analytics.triggerAnalytics("plan.created");

            // NASTY hack of disabling the _scrollToView method. This way when we reload backlog after creating the issue
            // the user doesn't experience the ugly jumpy scrolling effect. When the data is loaded we restore original
            // scrolling function so when other use it, it is ok. Unfortunately there is no other way to do this
            var originalScrollToView = GH.BacklogView._scrollToView;
            GH.BacklogView._scrollToView = $.noop;

            var $backlog = $('#ghx-backlog');
            var scrollTop = $backlog.scrollTop(); // preserve scroll position before we refresh the backlog

            GH.BacklogController.reloadAndSelectCreatedIssues([issue]).done(function reloadAndSelectCreatedIssuesDone() {
                // restore the original function to JAG
                GH.BacklogView._scrollToView = originalScrollToView;

                if (!GH.BacklogModel.isIssueVisible(issue.issueKey)) {
                    widget.analytics.triggerAnalytics("plan.createdNotVisible");
                }

                $backlog.scrollTop(scrollTop); // restore scroll position AFTER we refresh the backlog
                Util.scrollElementToView($backlog, widget.view.$el); // make sure widget is visible and scroll if needed

                // if widget is permanently inactive, we don't want to reactivate it, as it would mean opening the dialog again
                if (widget.model.getLockState() !== widget.model.constants.STATE_LOCK_PERM_INACTIVE) {
                    manager.activateWidget(widget);
                }
                JIRA.trace("inline.create.backlog.refreshed");
            });
        },
        addOverridesOnBeforeIssueCreated: function addOverridesOnBeforeIssueCreated(widget, data) {
            data.overrides = data.overrides || {};
            //add epic key
            var epicKey = GH.EpicController.getFilteredEpicKey();
            if (epicKey && epicKey !== "none") {
                var fieldName = GH.EpicConfig.getEpicLinkFieldName();
                data.overrides[fieldName] = epicKey;
            }

            //add version id
            var versionId = GH.VersionController.getFilteredVersionId();
            if (versionId && versionId !== "none") {
                data.overrides.fixVersion = versionId;
            }
        },
        _createNewWidget: function _createNewWidget(id) {
            var widgetView = WidgetGroup.prototype._createNewWidget.apply(this, arguments);
            widgetView.widget.on("beforeIssueCreated", this.addOverridesOnBeforeIssueCreated);
            widgetView.widget.on("issueCreated", this.issueCreatedHandler);
            return widgetView;
        },
        setBoardJQL: function setBoardJQL(jql) {
            this.boardJQL = jql;
            this._syncJQLs();
        },
        _syncJQLs: function _syncJQL() {
            var allJQLs = [];
            if (this.boardJQL) {
                allJQLs.push(this.boardJQL);
            }
            allJQLs.push.apply(allJQLs, this.filterJQLs);
            //update JQLs only when there is at least one JQL set
            if (allJQLs.length) {
                this.setCurrentJqls(allJQLs);
            }
        },
        setFilterJQLs: function setFilterJQLs(jqls) {
            this.filterJQLs = jqls;
            this._syncJQLs();
        }

    });
});