define('jira/inline-issue-create/agile/views/description', [
    'jira/inline-issue-create/views/description',
    'jquery',
    'underscore'
], function(
    DescriptionView,
    $,
    _
) {
    "use strict";

    var AgileDescriptionView = DescriptionView.extend({
        template: JIRA.Templates.InlineIssueCreate.Agile.description,
        ui: {
            selectedIssueTypeName: '.iic-widget__description__selected-issue-type-name',    // used in qunit test
            sectionDropdownTrigger: '.iic-widget__description__section-select-trigger',
            sectionDropdownItem: '.iic-widget__description__section-select a',
            sectionDropdown: '.iic-widget__description__section-select'                     // used in webdriver test
        },
        modelEvents: _.extend({
            "change:lockState": function onLockStateChange(m, state) {
                if (state === this.model.constants.STATE_LOCK_SENDING) {
                    this.disable();
                } else {
                    this.enable();
                }
            }
        }, DescriptionView.prototype.modelEvents),
        initialize: function initialize() {
            _.bindAll(this, 'onDropdownShow', 'onItemClick');
        },
        onRender: function onRender() {
            this.unwrapTemplate();
            this.ui.sectionDropdown.on("aui-dropdown2-show", this.onDropdownShow);
            this.ui.sectionDropdownItem.on("click", this.onItemClick);
        },
        // SW-3720: this has no effect in AUI 5.9.17; AUI just re-re-positions the dropdown menu after
        onDropdownShow: function(e) {
            // we don't want dropdown to be attached to body so we put it back where it was
            // it has to be done as early as possible as there might be some styling that affects the appearance
            // necessary to get the dropdown menu to move with page scroll
            var $dropdown = this.ui.sectionDropdown;
            $dropdown.appendTo(this.$el);

            var triggerOffset = this.ui.sectionDropdownTrigger.offset();
            var triggerPosition = this.ui.sectionDropdownTrigger.position();        // including margins
            var triggerHeight = this.ui.sectionDropdownTrigger.outerHeight();
            var dropdownHeight = $dropdown.height();
            var isDropdownMenuBelowPage = $("body").outerHeight(true) < triggerOffset.top + triggerHeight + dropdownHeight;
            // re-position the dropdown relative to the trigger button
            $dropdown.css({
                left: triggerPosition.left,
                top: (isDropdownMenuBelowPage ? triggerPosition.top - dropdownHeight : triggerPosition.top + triggerHeight) + "px"
            });
            if (isDropdownMenuBelowPage) {
                $dropdown.addClass("aui-dropdown2-alignment-top");
                this.ui.sectionDropdownTrigger.addClass("iic-widget__issue-type-selector__trigger_opened-up");
            }
        },
        onItemClick: function(e) {
            this.trigger("selected", $(e.target));
        },
        disable: function disable() {
            if (this.ui.sectionDropdownTrigger.attr) {
                this.ui.sectionDropdownTrigger.attr("aria-disabled", true);
            }
        },
        enable: function enable() {
            if (this.ui.sectionDropdownTrigger.attr) {
                this.ui.sectionDropdownTrigger.attr("aria-disabled", false);
            }
        },
        serializeData: function serializeData() {
            var data = {};
            var currentSection = this.allSections.get(this.currentSectionId);
            if (this.model.getSelectedIssueType()) {
                data = this.model.getSelectedIssueType().toJSON();
            }

            var currentId = this.currentSectionId || -1;
            var filteredSections = this.allSections.toJSON().filter(function filterOutCurrentSection(section) {
                return section.id !== currentId;
            });

            return {
                issueTypeName: data.name,
                widgetId: this.model.cid,
                currentSection: (currentSection) ? currentSection.getTranslatedName() : "",
                sections: filteredSections
            };
        }
    });

    return AgileDescriptionView;
});