define("jira/inline-issue-create/lib/marionette", [
    "jquery",
    "jira/inline-issue-create/lib/backbone",
    "atlassian/libs/underscore-1.5.2",
    "atlassian/libs/factories/marionette-2.1.0"
], function($, Backbone, _, marionetteFactory) {
    "use strict";
    var Marionette =  marionetteFactory(_, Backbone);

    /**
     * This method unwraps the Backbone.View.
     *
     * By default, Backbone will create a <di`v> and render the template inside. By calling this
     * method, you can get rid of that <div>, so the main element in your template will be the
     * root element in your template.
     */
    var extensions = {
        unwrapTemplate: function unwrapTemplate() {
            var children = this.$el.children();
            if (children.length > 1) {
                AJS.warn("[IIC] Unwrapping template with more than one child - some content will be lost");
            }

            var child = $(children.get(0));
            if (this.$el.parent().length) {
                // If the template is already rendered in the page
                this.$el.replaceWith(child);
                this.setElement(child);
            } else {
                // If the template is in memory
                this.setElement(child);
            }
        }
    };

    _.extend(Marionette.ItemView.prototype, extensions);
    _.extend(Marionette.CompositeView.prototype, extensions);
    _.extend(Marionette.CollectionView.prototype, extensions);
    _.extend(Marionette.LayoutView.prototype, extensions);

    return Marionette;
});