define('jira/inline-issue-create/prefillable-create-issue-dialog', [
    'wrm/require',
    'jquery',
    'underscore',
    'jira/inline-issue-create/lib/marionette',
    'jira/loading/loading',
    'jira/flag',
    'jira/inline-issue-create/prefillable-create-issue-dialog/init-form'
], function (
    wrmRequire,
    $,
    _,
    Marionette,
    Loading,
    Flag,
    initForm
) {
    "use strict";

    var ajsDim = AJS.dim;
    var ajsUndim = AJS.undim;

    var showLoadingIndicator = function () {
        ajsDim();
        Loading.showLoadingIndicator();
    };
    var hideLoadingIndicator = function () {
        ajsUndim();
        Loading.hideLoadingIndicator();
    };

    /**
     * Factory to create Create Issue Form promise
     *
     * @return promise that is resolved with JIRA.Forms.Container
     */
    var createPrefillableCreateIssueForm = function createPrefillableCreateIssueForm(
        fieldValuesRetrieved,
        shouldShowLoadingIndicator
    ) {
        var deferred = new $.Deferred();

        if (shouldShowLoadingIndicator) {
            showLoadingIndicator();
        }

        wrmRequire(['wr!com.atlassian.jira.jira-quick-edit-plugin:quick-create-issue'], initForm.bind(undefined, deferred, fieldValuesRetrieved)).fail(function () {
            if (shouldShowLoadingIndicator) {
                hideLoadingIndicator();
            }
            Flag.showErrorMsg(null, AJS.I18n.getText("common.forms.ajax.commserror"));
        });

        return deferred.promise();
    };

    return {
        createPrefillableCreateIssueForm: createPrefillableCreateIssueForm
    };
});

define('jira/inline-issue-create/prefillable-create-issue-dialog/custom-form-container-factory', [
    'jquery',
    'underscore'
], function (
    $,
    _
) {
    "use strict";

    var JiraFormsContainer = JIRA.Forms.Container;

    var build = function () {
        return JiraFormsContainer.extend({
            lazyInit: function lazyInit() {
                var options = this.options.call(this);
                this.prefilledValues = options.prefilledValues;
                this.prefilledValues.fieldsToRetain = _.keys(options.prefilledValues);
                this.prefilledValues =  $.param(options.prefilledValues);

                // Override options to just return what was evaluated and not evaluate it twice.
                // This way extra objects won't get created when super tries to call options again .
                this.options = function overridenOpitons() {
                    return options;
                };
                return this._super();
            },
            /**
             * Renders quick form. What is actually rendered is based apon user configuration. Full form will be showed first,
             * but if user switches to configurable form that will be persisted.
             *
             * It was extended, to use values retrieved from inline issue create JQL context.
             *
             * @return jQuery.Deferred
             */
            render: function render() {
                var instance = this,
                    deferred = $.Deferred();
                // re-evaluate options
                this.lazyInit();

                // values provided from context should be treated as they were provided by user
                // for backwards compatibility reasons check whether method is there
                if(_.isFunction(instance.model.markFieldAsDirty)) {
                    Object.keys(this.options().prefilledValues).forEach(function(key) {
                        instance.model.markFieldAsDirty(key);
                    });
                }

                instance.model.getUseConfigurableForm().done(function getUseConfigurableFormDone(answer) {
                    if (answer === true) {
                        instance.configurableForm.render(instance.prefilledValues).done(function rendered(el, scripts) {
                            deferred.resolveWith(instance, [instance.$element]);
                            instance.$element.append(scripts);
                        });
                    } else {
                        instance.unconfigurableForm.render(instance.prefilledValues).done(function rendered(el, scripts) {
                            deferred.resolveWith(instance, [instance.$element, scripts]);
                            instance.$element.append(scripts);
                        });
                    }
                }).fail(function getUseConfigurableFormFailed() {
                    deferred.resolveWith(instance, [instance.$element]);
                });

                return deferred.promise();
            }
        });
    };
    return {build: build};
});

define('jira/inline-issue-create/prefillable-create-issue-dialog/ondone', [
    'underscore',
    'jira/inline-issue-create/prefillable-create-issue-dialog/custom-form-container-factory'
], function (
    _,
    CustomFormContainerFactory
) {
    "use strict";

    var JiraFormsCreateIssueModel = JIRA.Forms.CreateIssueModel;
    var JiraFormsConfigurableCreateIssueForm = JIRA.Forms.ConfigurableCreateIssueForm;
    var JiraFormsUnconfigurableCreateIssueForm = JIRA.Forms.UnconfigurableCreateIssueForm;
    var JiraFormsCreateIssueError = JIRA.Forms.CreateIssueError;
    var applyErrorsToForm = JIRA.applyErrorsToForm;
    var applyErrorMessageToForm = JIRA.applyErrorMessageToForm;

    return function (deferred, fieldValuesRetrieved)  {
        if (!_.isObject(fieldValuesRetrieved)) {
            throw new Error("You must provide promise that will resolve with fieldValues to create this form. Use standard create issue form if you have none.");
        }

        var data;
        fieldValuesRetrieved.done(function whenInitializedAndHasFields(responseData) {
            data = responseData;

            data.prefilledFields = data.prefilledFields || {};
            data.errors = data.errors || {};
            data.errorMessages = data.errorMessages || {};
        }).fail(function whenFailedInitialization() {
            data = {
                prefilledFields: {},
                errors: {},
                errorMessages: {}
            };
        });

        // Copied from Quick Edit plugin to override the title
        var CustomFormContainer = CustomFormContainerFactory.build();
        var form = new CustomFormContainer(function containerInitFunction() {
            var containerOptions = {
                title: AJS.I18n.getText('admin.issue.operations.create'),
                id: "prefillable-create-issue-dialog",
                globalEventNamespaces: ["PrefillableCreateIssueDialog"],
                issueType: undefined // we will set that later when context is resolved
            };

            // model that gets fields and sets user preferences
            var model = new JiraFormsCreateIssueModel({
                projectId: undefined, // we will set that later when context is resolved
                issueType: undefined // we will set that later when context is resolved
            });

            var configurableForm = new JiraFormsConfigurableCreateIssueForm({
                model: model,
                title: containerOptions.title,
                globalEventNamespaces: containerOptions.globalEventNamespaces
            });

            var unconfigurableForm = new JiraFormsUnconfigurableCreateIssueForm({
                model: model,
                title: containerOptions.title,
                globalEventNamespaces: containerOptions.globalEventNamespaces
            });

            return {
                globalEventNamespaces: containerOptions.globalEventNamespaces,
                model: model,
                errorHandler: new JiraFormsCreateIssueError(),
                configurableForm: configurableForm,
                unconfigurableForm: unconfigurableForm,
                // when this variable is used it will be already defined because
                // this function isn't called until AFTER fieldValuesRetrieved is resolved
                prefilledValues: data.prefilledFields
            };
        });

        var dialog = form.asDialog({
            windowTitle: AJS.I18n.getText('admin.issue.operations.create'),
            id: "prefillable-create-issue-dialog"
        });

        // we can modify dialog's options after creation, specifically the
        // delayShowUntil option, as it is used in the show method for the first time
        dialog.options.delayShowUntil = function delayShowUntilFieldValuesRetrieved() {
            return fieldValuesRetrieved;
        };

        form.asDialog = function asDialog() {
            return form.dialog;
        };

        dialog.onContentReady(function formInitialized() {
            if (_.keys(data.errors).length) {
                // add global error message indicating that there are field errors            }
                data.errorMessages.unshift(AJS.I18n.getText("iic.dialog.errors"));
                // add per-field error messages
                applyErrorsToForm(form.$element, data.errors);
            }
            if (data.errorMessages.length) {
                // add global error message, join multiple messsages with <br> if needed
                applyErrorMessageToForm(form.$element, data.errorMessages.join("<br/>"));
            }
        });

        deferred.resolve(form);
    };
});
