define('jira/inline-issue-create/prefillable-create-issue-dialog/custom-form-container-factory', [
    'jquery',
    'underscore'
], function (
    $,
    _
) {
    "use strict";

    var build = function () {
        var JiraFormsContainer = JIRA.Forms.Container;

        return JiraFormsContainer.extend({
            lazyInit: function lazyInit() {
                var options = this.options.call(this);
                this.prefilledValues = options.prefilledValues;
                this.prefilledValues.fieldsToRetain = _.keys(options.prefilledValues);
                this.prefilledValues =  $.param(options.prefilledValues);

                // Override options to just return what was evaluated and not evaluate it twice.
                // This way extra objects won't get created when super tries to call options again .
                this.options = function overridenOpitons() {
                    return options;
                };
                return this._super();
            },
            /**
             * Renders quick form. What is actually rendered is based apon user configuration. Full form will be showed first,
             * but if user switches to configurable form that will be persisted.
             *
             * It was extended, to use values retrieved from inline issue create JQL context.
             *
             * @return jQuery.Deferred
             */
            render: function render() {
                var instance = this,
                    deferred = $.Deferred();
                // re-evaluate options
                this.lazyInit();

                // values provided from context should be treated as they were provided by user
                // for backwards compatibility reasons check whether method is there
                if(_.isFunction(instance.model.markFieldAsDirty)) {
                    Object.keys(this.options().prefilledValues).forEach(function(key) {
                        instance.model.markFieldAsDirty(key);
                    });
                }

                instance.model.getUseConfigurableForm().done(function getUseConfigurableFormDone(answer) {
                    if (answer === true) {
                        instance.configurableForm.render(instance.prefilledValues).done(function rendered(el, scripts) {
                            deferred.resolveWith(instance, [instance.$element]);
                            instance.$element.append(scripts);
                        });
                    } else {
                        instance.unconfigurableForm.render(instance.prefilledValues).done(function rendered(el, scripts) {
                            deferred.resolveWith(instance, [instance.$element, scripts]);
                            instance.$element.append(scripts);
                        });
                    }
                }).fail(function getUseConfigurableFormFailed() {
                    deferred.resolveWith(instance, [instance.$element]);
                });

                return deferred.promise();
            }
        });
    };
    return {build: build};
});
