define('jira/inline-issue-create/views/description', [
    'jquery',
    'jira/inline-issue-create/lib/marionette'
], function (
    $,
    Marionette
) {
    "use strict";

    var DescriptionView = Marionette.ItemView.extend({
        template: JIRA.Templates.InlineIssueCreate.description,
        ui: {
            selectedIssueTypeName: '.iic-widget__description__selected-issue-type-name'
        },
        modelEvents: {
            "change:selectedIssueType": function onSelectedIssueTypeChange() {
                var name = (this.model.getSelectedIssueType() && this.model.getSelectedIssueType().getName()) || "";
                if (name) {
                    this.$el.removeClass("iic-widget__description_invisible");
                    this.ui.selectedIssueTypeName.text(name);
                } else {
                    this.$el.addClass("iic-widget__description_invisible");
                }
            }
        },
        serializeData: function serializeData() {
            var data = {};
            if (this.model.getSelectedIssueType()) {
                data = this.model.getSelectedIssueType().toJSON();
            }
            return {
                issueTypeName: data.name
            };
        },
        onRender: function onRender() {
            this.unwrapTemplate();
        }
    });

    return DescriptionView;
});