define('jira/inline-issue-create/views/default-trigger', [
    'jquery',
    'jira/inline-issue-create/lib/marionette'
], function (
    $,
    Marionette
) {
    "use strict";

    var DefaultTrigger = Marionette.ItemView.extend({
        template: JIRA.Templates.InlineIssueCreate.trigger,
        ui: {
            trigger: ' .iic-trigger'
        },
        events: {
            "click @ui.trigger": function onClick(e) {
                e.preventDefault();
                this.trigger("selected");
            }
        },
        initialize: function initialize(options) {
            this.widget = options.widget;

            this.listenTo(this.widget, "activated", this.hide);
            this.listenTo(this.widget, "deactivated", this.show);
        },
        onRender: function onRender() {
            this.unwrapTemplate();
            if (this.widget.model.getState() === this.widget.model.constants.STATE_ACTIVE) {
                this.hide();
            }
        },
        hide: function hide() {
            this.ui.trigger.addClass("iic-trigger_hidden");
        },
        show: function show() {
            this.ui.trigger.removeClass("iic-trigger_hidden");
        }
    });

    return DefaultTrigger;
});