define('jira/inline-issue-create/analytics', [
    'jira/analytics',
    'jira/inline-issue-create/lib/marionette'
], function (
    analytics,
    Marionette
    ) {
    "use strict";

    return Marionette.Controller.extend({
        initialize: function initialize(options) {
            this.loadTimestamp = new Date().getTime();
            var widget = options.widget;
            this.widgetId = widget.model.cid.substring(1);
            this.projects = widget.projects;

            this.listenTo(widget, "issueCreated", this.onIssueCreated);
            this.listenTo(widget, "openCreateIssueDialog", this.onOpenCreateIssueDialog);
            this.listenTo(widget, "activated", this.onActivated);
            this.listenTo(widget, "deactivated", this.onDeactivated);
        },
        triggerAnalytics: function triggerAnalytics(name, params) {
            var projectId = "";
            var projectType = "";
            if (this.projects && this.projects.size() > 0) {
                var currentProject = this.projects.first();
                projectId = currentProject.get("id");
                projectType = currentProject.get("type");
            }
            var args = _.defaults({}, params, {
                instance: this.widgetId,
                timestarted: this.loadTimestamp,
                projectId: projectId,
                projectType: projectType
            });
            analytics.send({ name: "jira.inlinecreate." + name, data: args });
        },
        onOpenCreateIssueDialog: function onOpenCreateIssueDialog(args) {
            this.triggerAnalytics("openDialog", {
                reason: args.reason
            });
        },
        onIssueCreated: function onIssueCreated(issue, prefilledFields, widget, args) {
            if (args.source === "inline") {
                this.triggerAnalytics("issueCreatedInline");
            } else {
                this.triggerAnalytics("issueCreatedDialog");
            }
        },
        onDeactivated: function onDeactivated() {
            this.triggerAnalytics("deactivated");
        },
        onActivated: function onActivated() {
            this.triggerAnalytics("activated");
        }
    });
});
