define('jira/inline-issue-create/entities/inline-issue', [
    'jquery',
    'underscore',
    'jira/inline-issue-create/lib/brace'
], function (
    $,
    _,
    Brace
) {
    "use strict";

    return Brace.Model.extend({
        initialize: function initialize() {
            this._isSaving = false;
        },

        save: function save() {
            var instance = this;
            var deferred = $.ajax(AJS.contextPath() + "/rest/inline-create/1.0/issue", {
                data: JSON.stringify(this.toJSON()),
                contentType: 'application/json',
                type: 'POST'
            });
            this._isSaving = true;
            return deferred.always(function unmarkSending() {
                instance._isSaving = false;
            });
        },

        isSaving: function isSaving() {
            return this._isSaving;
        }
    });
});

