AJS.test.require("com.atlassian.jira.plugins.jira-importers-trello-plugin:trelloProjectSelectionPage", function() {

	module("JIRA.Importer.Trello.ProjectMappingPage", {
		setup: function () {
			this.view = new JIRA.Importer.Trello.ProjectSelectionFormView();
			ok(this.view !== null, "Can construct a ProjectSelectionFormView");
		}
	});

	test("restrictDuplicateValues() does nothing with no fields", function () {
		var $fields = AJS.$("");
		var error = "error";
		this.view.restrictDuplicateValues($fields, error);
		ok(_.keys(this.view.errors).length === 0, "There should be no errors reported.");
	});

	test("rrestrictDuplicateValues() does nothing with a single field present", function () {
		var $fields = AJS.$("<input />").val("value");
		var error = "error";
		this.view.restrictDuplicateValues($fields, error);
		ok(_.keys(this.view.errors).length === 0, "There should be no errors reported.");
	});

	test("restrictDuplicateValues() does nothing with multiple, non-conflicting fields", function () {
		var $fields = AJS.$("<input name='i1' value='v1' /><input name='i2' value='v2' />");
		var error = "error";
		this.view.restrictDuplicateValues($fields, error);
		ok(_.keys(this.view.errors).length === 0, "No errors should be reported with 2 non-conflicting errors");

		$fields.append(AJS.$("<input name='i3' value='v3' />"));
		this.view.restrictDuplicateValues($fields, error);
		ok(_.keys(this.view.errors).length === 0, "No errors should be reported with 3 non-conflicting errors");
	});

	test("restrictDuplicateValues() handles simple conflicts, and correctly updates errors messages when conflict removed", function () {
		var $fields = AJS.$("<input name='i1' value='v1' /><input name='i2' value='v1' />");
		var error = "error";
		this.view.restrictDuplicateValues($fields, error);
		ok("i1" in this.view.errors, "Error reported for element i1");
		ok(error in this.view.errors["i1"], "Correct error is report for element i1");

		ok("i2" in this.view.errors, "Error reported for element i2");
		ok(error in this.view.errors["i2"], "Correct error is report for element i2");

		$fields.first().val("v2");
		this.view.restrictDuplicateValues($fields, error);
		ok(!(error in this.view.errors["i1"]), "Error was removed from i1");
		ok(!(error in this.view.errors["i2"]), "Error was removed from i2");
	});

	test("restrictDuplicateValues() handle multiple conflicting fields, including correctly updating error messages when conflicts removed", function () {
		var $fields = AJS.$("<input name='i1' value='v1' /><input name='i2' value='v1' /><input name='i3' value='v1' />");
		var error = "error";
		this.view.restrictDuplicateValues($fields, error);
		ok("i1" in this.view.errors, "Error reported for element i1");
		ok(error in this.view.errors["i1"], "Correct error is report for element i1");

		ok("i2" in this.view.errors, "Error reported for element i2");
		ok(error in this.view.errors["i2"], "Correct error is report for element i2");

		ok("i3" in this.view.errors, "Error reported for element i3");
		ok(error in this.view.errors["i3"], "Correct error is report for element i3");

		$fields.first().val("v2");
		this.view.restrictDuplicateValues($fields, error);
		ok(!(error in this.view.errors["i1"]), "No error is report for element i1");
		ok(error in this.view.errors["i2"], "Correct error is report for element i2");
		ok(error in this.view.errors["i3"], "Correct error is report for element i3");

		$fields.last().val("v3");
		this.view.restrictDuplicateValues($fields, error);
		ok(!(error in this.view.errors["i1"]), "No error is report for element i1");
		ok(!(error in this.view.errors["i2"]), "No error is report for element i2");
		ok(!(error in this.view.errors["i3"]), "No error is report for element i3");
	});

	test("addError() ignores empty error strings", function () {
		var $field = AJS.$("<input name='i1' />");
		this.view.addError($field, "");
		ok(!("i1" in this.view.errors), "No error should be added when no error is provided.");
	});

	test("addError() correctly appends multiple errors to the same field", function () {
		var $field = AJS.$("<input name='i1' />");
		this.view.addError($field, "error1");
		this.view.addError($field, "error");
		ok("error1" in this.view.errors["i1"], "First error added correctly.");
		ok("error" in this.view.errors["i1"], "Second error added correctly.");
	});

	test("removeError() only removes the exact error message specified", function () {
		var $field = AJS.$("<input name='i1' />");
		this.view.addError($field, "error1");
		this.view.addError($field, "error");
		this.view.removeError($field, "error");
		ok("error1" in this.view.errors["i1"], "First error was not removed.");
		ok(!("error" in this.view.errors["i1"]), "Second error was removed.");

		this.view.removeError($field, "error1");
		ok(!("error1" in this.view.errors["i1"]), "First error was removed.");
		ok(!("error" in this.view.errors["i1"]), "Second error was removed.");
	});
});
