/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.trello.web;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.plugins.importer.extensions.ImporterController;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.trello.TrelloImporterConfigBean;
import com.atlassian.jira.plugins.importer.trello.agileutils.BoardManagerAccessor;
import com.atlassian.jira.plugins.importer.trello.fetch.TrelloApiImpl;
import com.atlassian.jira.plugins.importer.web.AbstractSetupPage;
import com.atlassian.jira.plugins.importer.web.ConfigFileHandler;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.ImmutableList;
import org.scribe.builder.ServiceBuilder;
import org.scribe.exceptions.OAuthConnectionException;
import org.scribe.model.SignatureType;
import org.scribe.model.Token;
import org.scribe.oauth.OAuthService;
import webwork.action.ActionContext;

@WebSudoRequired
public class TrelloSetupPage
extends AbstractSetupPage {
    private final ConfigFileHandler configFileHandler;
    private final String jiraUrl;
    private final String key = "0cbcbb81b60d256a6080a3c214b678ba";
    private final String secret = "50e2fec61b9719c5205cb103b4481d3a3258944fd473e305a14e6beaa0c8e774";
    private final BoardManagerAccessor boardManagerAccessor;

    public TrelloSetupPage(UsageTrackingService usageTrackingService, @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport ConfigFileHandler configFileHandler, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport EventPublisher eventPublisher, BoardManagerAccessor boardManagerAccessor) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor, eventPublisher);
        this.configFileHandler = configFileHandler;
        this.jiraUrl = applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
        this.boardManagerAccessor = boardManagerAccessor;
    }

    public String doDefault() throws Exception {
        if (!this.isAdministrator()) {
            return "denied";
        }
        ImporterController controller = this.getController();
        if (controller == null) {
            return "restartimporterneeded";
        }
        return "input";
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        ImporterController controller = this.getController();
        if (controller == null) {
            return "restartimporterneeded";
        }
        if (!this.isPreviousClicked() && !controller.createImportProcessBean((AbstractSetupPage)this)) {
            return "input";
        }
        if (this.isNextClicked()) {
            Token requestToken;
            OAuthService service = new ServiceBuilder().provider(TrelloApiImpl.class).signatureType(SignatureType.Header).apiKey("0cbcbb81b60d256a6080a3c214b678ba").apiSecret("50e2fec61b9719c5205cb103b4481d3a3258944fd473e305a14e6beaa0c8e774").callback(this.jiraUrl + "/secure/admin/views/TrelloProjectSelectionPage!default.jspa?externalSystem=com.atlassian.jira.plugins.jira-importers-trello-plugin:TrelloImporterKey").build();
            try {
                requestToken = service.getRequestToken();
            }
            catch (OAuthConnectionException exception) {
                this.addErrorMessage(exception.getLocalizedMessage());
                return "input";
            }
            ActionContext.getSession().put("issue.importer.jira.bitbucket.oauthRequestToken", requestToken);
            TrelloImporterConfigBean configBean = this.getConfigBean();
            configBean.getTrelloImporterClient().setService(service);
            this.getRedirect(service.getAuthorizationUrl(requestToken), true);
            return "none";
        }
        return super.doExecute();
    }

    protected void doValidation() {
        if (this.isPreviousClicked()) {
            return;
        }
        super.doValidation();
        this.configFileHandler.verifyConfigFileParam((AbstractSetupPage)this);
    }

    public TrelloImporterConfigBean getConfigBean() {
        try {
            if (this.getController() == null || this.getController().getImportProcessBeanFromSession() == null) {
                return null;
            }
            return (TrelloImporterConfigBean)this.getController().getImportProcessBeanFromSession().getConfigBean();
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public Iterable<String> getRequiredResources() {
        return ImmutableList.of((Object)"com.atlassian.jira.plugins.jira-importers-trello-plugin:setupPage");
    }

    public boolean votingEnabled() {
        return this.getApplicationProperties().getOption("jira.option.voting");
    }

    public boolean subTasksEnabled() {
        return this.getApplicationProperties().getOption("jira.option.allowsubtasks");
    }

    public boolean attachmentsEnabled() {
        return this.getApplicationProperties().getOption("jira.option.allowattachments");
    }

    public boolean isJiraAgileInstalled() {
        return this.boardManagerAccessor.getBoardManager() != null;
    }

    public boolean isJiraAgileDisabled() {
        return this.isJiraAgileInstalled() && this.boardManagerAccessor.getBoardManager().isJiraAgileDisabled();
    }

    public boolean isJiraAgileLicensed() {
        return this.isJiraAgileInstalled() && this.boardManagerAccessor.getBoardManager().isJiraAgileEnabled();
    }

    public boolean hasRequiredPermissions() {
        return this.getGlobalPermissionManager().hasPermission(22, this.getLoggedInApplicationUser());
    }

    public boolean importerWarnings() {
        return !this.votingEnabled() || !this.subTasksEnabled() || !this.attachmentsEnabled() || !this.isJiraAgileLicensed() || !this.hasRequiredPermissions();
    }
}

