/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.trello.transformers;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.config.ResolutionManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalHistoryGroup;
import com.atlassian.jira.plugins.importer.external.beans.ExternalHistoryItem;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.trello.TrelloImporterClient;
import com.atlassian.jira.plugins.importer.trello.agileutils.BoardManager;
import com.atlassian.jira.plugins.importer.trello.model.Action;
import com.atlassian.jira.plugins.importer.trello.model.Attachment;
import com.atlassian.jira.plugins.importer.trello.model.Card;
import com.atlassian.jira.plugins.importer.trello.model.Checklist;
import com.atlassian.jira.plugins.importer.trello.model.ChecklistItem;
import com.atlassian.jira.plugins.importer.trello.model.Label;
import com.atlassian.jira.plugins.importer.trello.model.TrelloList;
import com.atlassian.jira.plugins.importer.trello.model.User;
import com.atlassian.jira.plugins.importer.trello.transformers.AttachmentHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class CardTransformer
implements Function<Card, ExternalIssue> {
    private final TrelloImporterClient client;
    private final ImportLogger log;
    private final I18nHelper i18nHelper;
    private final ApplicationProperties properties;
    private final PriorityManager priorityManager;
    private final ResolutionManager resolutionManager;
    private final ExternalProject externalProject;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final ProjectManager projectManager;
    private final ConstantsManager constantsManager;
    private final BoardManager boardManager;

    public CardTransformer(TrelloImporterClient client, ImportLogger log, ApplicationProperties properties, PriorityManager priorityManager, ResolutionManager resolutionManager, ExternalProject externalProject, IssueTypeSchemeManager issueTypeSchemeManager, ProjectManager projectManager, ConstantsManager constantsManager, BoardManager boardManager) {
        this.client = client;
        this.log = log;
        this.i18nHelper = client.getI18nHelper();
        this.properties = properties;
        this.priorityManager = priorityManager;
        this.resolutionManager = resolutionManager;
        this.externalProject = externalProject;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.projectManager = projectManager;
        this.constantsManager = constantsManager;
        this.boardManager = boardManager;
    }

    public ExternalIssue apply(Card card) {
        ExternalIssue issue = new ExternalIssue();
        this.importBasicInformation(card, issue);
        this.importStatusAndResolution(card, issue);
        this.importIssueVoters(card, issue);
        this.importLabels(card, issue);
        this.importAssignee(card, issue);
        this.importSubtasks(card, issue);
        this.importComments(card, issue);
        this.importAttachments(card, issue);
        this.importReporter(card, issue);
        this.importHistory(card, issue);
        return issue;
    }

    private void importBasicInformation(Card card, ExternalIssue issue) {
        issue.setExternalId(card.getId());
        issue.setSummary(card.getName());
        issue.setDescription(card.getDesc());
        issue.setDuedate(card.getDue());
        issue.setIssueType(this.getIssueType(this.externalProject));
        issue.setPriority(this.getPriority(card));
    }

    private void importStatusAndResolution(Card card, ExternalIssue issue) {
        issue.setResolution(this.getResolution(card));
        issue.setStatus(this.getStatus(card));
    }

    private void importIssueVoters(Card card, ExternalIssue issue) {
        issue.setVoters(this.getMembersVoted(card));
    }

    private void importLabels(Card card, ExternalIssue issue) {
        issue.setLabels(this.getLabels(card));
    }

    private void importAssignee(Card card, ExternalIssue issue) {
        issue.setAssignee(this.getAssignee(card));
    }

    private void importSubtasks(Card card, ExternalIssue issue) {
        issue.setSubtasks(this.getSubTasks(card));
    }

    private void importComments(Card card, ExternalIssue issue) {
        issue.setComments(this.getComments(card));
    }

    private void importAttachments(Card card, ExternalIssue issue) {
        issue.setAttachments(this.getAttachments(card, new AttachmentHelper()));
    }

    private void importReporter(Card card, ExternalIssue issue) {
        issue.setReporter(this.getReporter(card));
    }

    private void importHistory(Card card, ExternalIssue issue) {
        issue.setHistory(this.getHistory(card));
    }

    @VisibleForTesting
    String getPriority(Card card) {
        if (this.priorityManager.getDefaultPriority() != null) {
            return this.priorityManager.getDefaultPriority().getName();
        }
        List priorities = this.priorityManager.getPriorities();
        return ((Priority)priorities.get(priorities.size() / 2)).getName();
    }

    @VisibleForTesting
    String getResolution(boolean closed) {
        if (!closed) {
            return null;
        }
        if (this.resolutionManager.getDefaultResolution() != null) {
            return this.resolutionManager.getDefaultResolution().getName();
        }
        List resolutions = this.resolutionManager.getResolutions();
        return ((Resolution)resolutions.get(0)).getName();
    }

    @VisibleForTesting
    String getResolution(Card card) {
        List<TrelloList> allLists = this.client.getParser().getBoard(this.client.getApi().getBoard(this.externalProject.getId())).getLists();
        boolean cardInLastList = false;
        if (allLists.size() > 0) {
            cardInLastList = allLists.get(allLists.size() - 1).getId().equals(card.getIdList());
        }
        return this.getResolution(card.isClosed() || cardInLastList);
    }

    @VisibleForTesting
    String getResolution(ChecklistItem checklistItem, Card card) {
        String cardResolution = this.getResolution(card);
        if (cardResolution != null) {
            return cardResolution;
        }
        return this.getResolution(checklistItem.getState() == ChecklistItem.State.COMPLETE);
    }

    @VisibleForTesting
    String getIssueType(ExternalProject externalProject) {
        Project project = this.projectManager.getProjectObjByKey(externalProject.getKey());
        IssueType defaultIssueType = this.issueTypeSchemeManager.getDefaultIssueType(project);
        if (defaultIssueType != null && !defaultIssueType.getName().equals(this.i18nHelper.getText("gh.issue.epic"))) {
            return defaultIssueType.getName();
        }
        Collection issueTypes = this.issueTypeSchemeManager.getNonSubTaskIssueTypesForProject(project);
        for (IssueType issueType : issueTypes) {
            if (issueType.getName().equals(this.i18nHelper.getText("gh.issue.epic"))) continue;
            return issueType.getName();
        }
        throw new RuntimeException(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.cardTransformer.error.issueTypeNotFound"));
    }

    @VisibleForTesting
    String getSubTaskIssueType(ExternalProject externalProject) {
        Project project = this.projectManager.getProjectObjByKey(externalProject.getKey());
        Collection issueTypes = this.issueTypeSchemeManager.getSubTaskIssueTypesForProject(project);
        if (issueTypes.size() == 0) {
            return null;
        }
        return ((IssueType)Iterables.get((Iterable)issueTypes, (int)0)).getName();
    }

    private Status getStatus(String listName) {
        for (Status status : this.constantsManager.getStatusObjects()) {
            if (!listName.equalsIgnoreCase(status.getName())) continue;
            return status;
        }
        throw new RuntimeException(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.cardTransformer.error.statusNotFound", listName));
    }

    @VisibleForTesting
    String getStatus(Card card) {
        if (card.isClosed()) {
            return this.constantsManager.getStatusByName(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.workflowHelper.archivedStatusName")).getId();
        }
        TrelloList list = this.client.getParser().getList(this.client.getApi().getList(card));
        return this.getStatus(list.getName()).getId();
    }

    @VisibleForTesting
    Collection<String> getMembersVoted(Card card) {
        if (card.getIdMembersVoted().size() > 0 && !this.properties.getOption("jira.option.voting")) {
            this.log.warn(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.cardTransformer.error.getMembersVoted.globallyDisabled"), new Object[0]);
            return Collections.EMPTY_LIST;
        }
        String reporter = this.getReporter(card);
        LinkedList membersVoted = Lists.newLinkedList();
        for (String idMemberVoted : card.getIdMembersVoted()) {
            User user = this.client.getParser().getUser(this.client.getApi().getUser(idMemberVoted));
            if (reporter != null && reporter.equals(user.getUsername())) {
                this.log.warn(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.cardTransformer.error.getMembersVoted"), new Object[0]);
                continue;
            }
            membersVoted.add(user.getUsername());
        }
        return membersVoted;
    }

    @VisibleForTesting
    Collection<String> getLabels(Card card) {
        LinkedList labels = Lists.newLinkedList();
        for (Label label : card.getLabels()) {
            if (label.getName() != null && label.getName().length() > 0) {
                labels.add(label.getName());
                continue;
            }
            labels.add(label.getColor());
        }
        return labels;
    }

    @VisibleForTesting
    String getAssignee(Card card) {
        List<User> members = card.getMembers();
        if (members.size() > 0) {
            return members.get(0).getUsername();
        }
        return null;
    }

    @VisibleForTesting
    Collection<ExternalIssue> getSubTasks(Card card) {
        if (card.getChecklists().size() > 0 && !this.properties.getOption("jira.option.allowsubtasks")) {
            this.log.warn(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.cardTransformer.error.getSubTask.globallyDisabled"), new Object[0]);
            return Collections.EMPTY_LIST;
        }
        if (card.getChecklists().size() > 0 && this.getSubTaskIssueType(this.externalProject) == null) {
            this.log.warn(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.cardTransformer.error.getSubTask.locallyDisabled"), new Object[0]);
            return Collections.EMPTY_LIST;
        }
        LinkedList subTasks = Lists.newLinkedList();
        for (Checklist checklist : card.getChecklists()) {
            for (ChecklistItem checklistItem : checklist.getCheckItems()) {
                ExternalIssue subTask = new ExternalIssue();
                subTask.setReporter(this.getReporter(card));
                subTask.setSummary(checklistItem.getName());
                subTask.setAssignee(this.getAssignee(card));
                subTask.setIssueType(this.getSubTaskIssueType(this.externalProject));
                subTask.setPriority(this.getPriority(card));
                subTask.setResolution(this.getResolution(checklistItem, card));
                if (checklistItem.getState() == ChecklistItem.State.COMPLETE) {
                    subTask.setStatus(this.constantsManager.getStatusByName(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.workflowHelper.archivedStatusName")).getId());
                } else {
                    subTask.setStatus(this.getStatus(card));
                }
                subTasks.add(subTask);
            }
        }
        return subTasks;
    }

    @VisibleForTesting
    Collection<ExternalComment> getComments(Card card) {
        LinkedList comments = Lists.newLinkedList();
        for (Action action : card.getActions()) {
            if (!action.getType().equals("commentCard")) continue;
            comments.add(new ExternalComment(action.getData().get("text").getAsString(), action.getMemberCreator().getUsername(), action.getDate()));
        }
        return comments;
    }

    @VisibleForTesting
    List<ExternalAttachment> getAttachments(Card card, AttachmentHelper attachmentHelper) {
        if (card.getAttachments().size() > 0 && !this.properties.getOption("jira.option.allowattachments")) {
            this.log.warn(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.cardTransformer.error.getAttachments.globallyDisabled"), new Object[0]);
            return Collections.EMPTY_LIST;
        }
        LinkedList attachments = Lists.newLinkedList();
        for (Attachment attachment : card.getAttachments()) {
            if (attachment.getBytes() > attachmentHelper.getMaxAttachmentSize()) {
                this.log.warn(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.transformers.CardTransformer.getAttachments.error", attachment.getName(), card.getName(), this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.transformers.CardTransformer.getAttachments.error.fileSize")), new Object[0]);
                continue;
            }
            AttachmentHelper.UniqueFile uniqueFile = attachmentHelper.getTemporaryUniqueFile(attachment.getName());
            try {
                FileUtils.copyURLToFile((URL)new URL(attachment.getUrl()), (File)uniqueFile.getFile());
            }
            catch (MalformedURLException e) {
                this.log.warn(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.transformers.CardTransformer.getAttachments.error", attachment.getName(), card.getName(), e.getLocalizedMessage()), new Object[0]);
                continue;
            }
            catch (IOException e) {
                this.log.warn(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.transformers.CardTransformer.getAttachments.error", attachment.getName(), card.getName(), this.i18nHelper.getText("com.atlassian.jira.plugins.importer.trello.transformers.CardTransformer.getAttachments.error.cannotCreateFile")), new Object[0]);
                continue;
            }
            String attacherIdMember = attachment.getIdMember();
            User attacherUser = !StringUtils.isBlank((String)attacherIdMember) ? this.client.getParser().getUser(this.client.getApi().getUser(attacherIdMember)) : null;
            String attacher = attacherUser != null ? attacherUser.getUsername() : null;
            ExternalAttachment externalAttachment = new ExternalAttachment(attachment.getName(), attachment.getUrl(), attachment.getDate(), attacher);
            externalAttachment.setAttachment(uniqueFile.getFile());
            attachments.add(externalAttachment);
        }
        return attachments;
    }

    @VisibleForTesting
    String getReporter(Card card) {
        for (Action action : card.getActions()) {
            if (!action.getType().equals("createCard")) continue;
            return action.getMemberCreator().getUsername();
        }
        return null;
    }

    @VisibleForTesting
    List<ExternalHistoryGroup> getHistory(Card card) {
        LinkedList historyGroups = Lists.newLinkedList();
        for (Action action : card.getActions()) {
            if (!action.getType().equals("updateCard")) continue;
            JsonObject data = action.getData();
            LinkedList items = Lists.newLinkedList();
            JsonObject oldCard = data.get("old").getAsJsonObject();
            JsonObject newCard = data.get("card").getAsJsonObject();
            for (Map.Entry oldEntry : oldCard.entrySet()) {
                String fieldName = (String)oldEntry.getKey();
                JsonElement newEntry = newCard.get(fieldName);
                String oldValue = ((JsonElement)oldEntry.getValue()).isJsonNull() ? "" : ((JsonElement)oldEntry.getValue()).getAsString();
                String newValue = null == newEntry || newEntry.isJsonNull() ? "" : newEntry.getAsString();
                String jiraField = Card.FIELDS_NAMES_TO_JIRA.get(fieldName);
                if (jiraField == null) continue;
                items.add(new ExternalHistoryItem("jira", jiraField, "", oldValue, "", newValue));
            }
            if (items.size() == 0) continue;
            historyGroups.add(new ExternalHistoryGroup(action.getMemberCreator().getUsername(), action.getDate(), (Collection)items));
        }
        return historyGroups;
    }
}

