/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.trello.transformers;

import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.trello.TrelloImporterClient;
import com.atlassian.jira.plugins.importer.trello.TrelloImporterConfigBean;
import com.atlassian.jira.plugins.importer.trello.WorkflowHelper;
import com.atlassian.jira.plugins.importer.trello.model.Board;
import com.google.common.base.Function;

public class BoardTransformer
implements Function<Board, ExternalProject> {
    private final TrelloImporterConfigBean configBean;
    private final WorkflowHelper workflowHelper;

    public BoardTransformer(TrelloImporterConfigBean configBean, WorkflowHelper workflowHelper) {
        this.configBean = configBean;
        this.workflowHelper = workflowHelper;
    }

    public synchronized ExternalProject apply(Board board) {
        ExternalProject project = new ExternalProject();
        project.setId(board.getId());
        project.setExternalName(board.getName());
        project.setDescription(board.getDesc());
        project.setUrl(board.getUrl());
        project.setKey(this.configBean.getProjectKey(board.getName()));
        project.setName(this.configBean.getProjectName(board.getName()));
        project.setLead(this.configBean.getProjectLead(board.getName()));
        project.setType(TrelloImporterClient.getDefaultProjectType());
        if (this.configBean.isProjectSelected(board.getName())) {
            project.setWorkflowSchemeName(this.workflowHelper.createWorkflowForBoard(project, board));
        }
        return project;
    }
}

