/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.trello.name;

import com.atlassian.jira.util.I18nHelper;
import org.apache.commons.lang.StringUtils;

public abstract class CopyNameFactory {
    protected static final int MAX_NUMBER_OF_COPIES = 10000;
    protected static final int MAX_LENGTH = 255;
    private final I18nHelper i18nHelper;

    public CopyNameFactory(I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
    }

    public String createFrom(String originalName) {
        if (!this.nameInUse(originalName)) {
            return StringUtils.abbreviate((String)originalName, (int)255);
        }
        String newName = StringUtils.abbreviate((String)this.i18nHelper.getText("common.words.copyof", originalName), (int)255);
        int copyNumber = 2;
        while (this.nameInUse(newName)) {
            if (copyNumber >= 10000) {
                throw new UnableToGenerateSuitableName();
            }
            newName = StringUtils.abbreviate((String)this.i18nHelper.getText("common.words.copyxof", String.valueOf(copyNumber), originalName), (int)255);
            ++copyNumber;
        }
        return newName;
    }

    protected abstract boolean nameInUse(String var1);

    public static class UnableToGenerateSuitableName
    extends RuntimeException {
    }
}

