/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.trello.model;

public class ChecklistItem {
    private final State state;
    private final String id;
    private final String name;

    public ChecklistItem(State state, String id, String name, long pos) {
        this.state = state;
        this.id = id;
        this.name = name;
    }

    public State getState() {
        return this.state;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "ChecklistItem{state=" + (Object)((Object)this.state) + ", id='" + this.id + '\'' + ", name='" + this.name + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChecklistItem)) {
            return false;
        }
        ChecklistItem that = (ChecklistItem)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.state == that.state;
    }

    public int hashCode() {
        int result = this.state != null ? this.state.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public static enum State {
        COMPLETE("complete"),
        INCOMPLETE("incomplete");

        private final String text;

        private State(String text) {
            this.text = text;
        }

        public static State getFromName(String name) {
            for (State state : State.values()) {
                if (!state.getText().equals(name)) continue;
                return state;
            }
            return null;
        }

        public String getText() {
            return this.text;
        }
    }
}

