/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.trello.fetch;

import com.atlassian.jira.plugins.importer.trello.model.Action;
import com.atlassian.jira.plugins.importer.trello.model.ChecklistItem;
import com.atlassian.jira.plugins.importer.trello.model.User;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import org.joda.time.DateTime;

public class ParserUtils {
    public static final JsonDeserializer<DateTime> DATE_TIME_JSON_DESERIALIZER = new JsonDeserializer<DateTime>(){

        public DateTime deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            return new DateTime((Object)json.getAsJsonPrimitive().getAsString());
        }
    };
    public static final JsonDeserializer<ChecklistItem.State> CHECKLIST_ITEM_STATE_DESERIALIZER = new JsonDeserializer<ChecklistItem.State>(){

        public ChecklistItem.State deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            return ChecklistItem.State.getFromName(json.getAsString());
        }
    };
    public static final JsonDeserializer<Action> ACTION_DESERIALIZER = new JsonDeserializer<Action>(){

        public Action deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            String id = json.getAsJsonObject().get("id").getAsString();
            String idMemberCreator = json.getAsJsonObject().get("idMemberCreator").getAsString();
            String actionType = json.getAsJsonObject().get("type").getAsString();
            DateTime date = (DateTime)context.deserialize(json.getAsJsonObject().get("date"), DateTime.class);
            User memberCreator = (User)context.deserialize(json.getAsJsonObject().get("memberCreator"), User.class);
            JsonObject data = json.getAsJsonObject().get("data").getAsJsonObject();
            return new Action(id, idMemberCreator, actionType, date, memberCreator, data);
        }
    };
}

