/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.trello;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComponent;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalLink;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.external.beans.ExternalVersion;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean2;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.importer.JiraDataImporter;
import com.atlassian.jira.plugins.importer.sample.Callbacks;
import com.atlassian.jira.plugins.importer.trello.TrelloImportProcessBean;
import com.atlassian.jira.plugins.importer.trello.TrelloImporterClient;
import com.atlassian.jira.plugins.importer.trello.TrelloImporterConfigBean;
import com.atlassian.jira.plugins.importer.trello.agileutils.BoardManager;
import com.atlassian.jira.plugins.importer.trello.agileutils.BoardManagerAccessor;
import com.atlassian.jira.plugins.importer.trello.model.TrelloList;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import webwork.action.ActionContext;

public class TrelloImporterDataBean
extends AbstractDataBean<TrelloImporterConfigBean> {
    private static final Logger log = Logger.getLogger(TrelloImporterDataBean.class);
    private static final String UNUSED_USERS_GROUP = "trello-import-unused-users";
    private final Map<String, Long> rapidBoards = Maps.newHashMap();
    private final BoardManagerAccessor boardManagerAccessor;
    private final GlobalPermissionManager globalPermissionManager;
    private final JiraAuthenticationContext authenticationContext;
    private final JiraDataImporter jiraDataImporter;
    private final IssueManager issueManager;
    private final TrelloImporterClient client;
    private final SoyTemplateRenderer soyTemplateRenderer;

    protected TrelloImporterDataBean(TrelloImportProcessBean importProcessBean, BoardManagerAccessor boardManagerAccessor, GlobalPermissionManager globalPermissionManager, JiraAuthenticationContext authenticationContext, JiraDataImporter jiraDataImporter, IssueManager issueManager, SoyTemplateRenderer soyTemplateRenderer) {
        super((AbstractConfigBean2)((TrelloImporterConfigBean)importProcessBean.getConfigBean()));
        this.boardManagerAccessor = boardManagerAccessor;
        this.globalPermissionManager = globalPermissionManager;
        this.authenticationContext = authenticationContext;
        this.jiraDataImporter = jiraDataImporter;
        this.issueManager = issueManager;
        this.client = ((TrelloImporterConfigBean)this.configBean).getTrelloImporterClient();
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    public Set<ExternalUser> getRequiredUsers(Collection<ExternalProject> externalProjects, ImportLogger importLogger) {
        return this.getAllUsers(importLogger);
    }

    public Set<ExternalUser> getAllUsers(ImportLogger importLogger) {
        return Sets.newHashSet(this.client.getUsers(this.getSelectedProjects(importLogger)));
    }

    public Set<ExternalProject> getAllProjects(ImportLogger importLogger) {
        return Sets.newHashSet(this.client.getAllProjects(importLogger));
    }

    public Collection<ExternalVersion> getVersions(ExternalProject externalProject, ImportLogger importLogger) {
        return Collections.EMPTY_SET;
    }

    public Collection<ExternalComponent> getComponents(ExternalProject externalProject, ImportLogger importLogger) {
        return Collections.EMPTY_SET;
    }

    public Iterator<ExternalIssue> getIssuesIterator(ExternalProject externalProject, ImportLogger importLogger) {
        return this.client.getIssuesIterator(externalProject, importLogger);
    }

    public Collection<ExternalAttachment> getAttachmentsForIssue(ExternalIssue externalIssue, ImportLogger log) {
        return externalIssue.getAttachments();
    }

    public long getTotalIssues(Set<ExternalProject> externalProjects, ImportLogger importLogger) {
        return this.client.getTotalIssues(this.getSelectedProjects(importLogger), importLogger);
    }

    public void cleanUp() {
    }

    public String getIssueKeyRegex() {
        return "(.+)";
    }

    public Collection<ExternalLink> getLinks(ImportLogger importLogger) {
        return Collections.EMPTY_LIST;
    }

    public String getUnusedUsersGroup() {
        return UNUSED_USERS_GROUP;
    }

    public boolean hasRequiredPermissionToCreateBoards() {
        return this.globalPermissionManager.hasPermission(22, this.authenticationContext.getUser());
    }

    public String getReturnLinks() {
        if (this.rapidBoards.isEmpty()) {
            return super.getReturnLinks();
        }
        HashMap soyData = MapBuilder.newBuilder().add((Object)"contextPath", (Object)ActionContext.getContext().getRequestImpl().getContextPath()).add((Object)"rapidBoards", this.rapidBoards).add((Object)"isJiraAgileLicensed", (Object)this.boardManagerAccessor.getBoardManager().isJiraAgileLicensed()).add((Object)"jiraAgileNotLicensedText", (Object)this.client.getI18nHelper().getText("com.atlassian.jira.plguins.importer.trello.trelloImporterDataBean.warning.jiraAgileNotLicensed")).add((Object)"takeMeToBoardText", (Object)this.client.getI18nHelper().getText("com.atlassian.jira.plguins.importer.trello.trelloImporterDataBean.takeme")).toHashMap();
        try {
            return this.soyTemplateRenderer.render("com.atlassian.jira.plugins.jira-importers-trello-plugin:soy-templates", "JIRA.Importers.Trello.rapidBoardLinks", (Map)soyData);
        }
        catch (SoyException e) {
            log.warn((Object)"Warning: could not render returnLinks.soy", (Throwable)e);
            return super.getReturnLinks();
        }
    }

    public Callbacks getCallbacks() {
        return new Callbacks(){
            private int rank = 1;

            public void afterProjectCreated(ExternalProject project, Project jiraProject) {
                ImportLogger importLog = TrelloImporterDataBean.this.jiraDataImporter.getLog();
                if (!TrelloImporterDataBean.this.hasRequiredPermissionToCreateBoards()) {
                    importLog.warn(TrelloImporterDataBean.this.client.getI18nHelper().getText("com.atlassian.jira.plguins.importer.trello.trelloImporterDataBean.warning.cannotCreateBoardPermissionError"), new Object[0]);
                    return;
                }
                if (TrelloImporterDataBean.this.boardManagerAccessor.getBoardManager() != null) {
                    BoardManager boardManager = TrelloImporterDataBean.this.boardManagerAccessor.getBoardManager();
                    List<TrelloList> lists = TrelloImporterDataBean.this.client.getParser().getBoard(TrelloImporterDataBean.this.client.getApi().getBoard(project.getId())).getLists();
                    Collections.sort(lists);
                    LinkedList listNames = Lists.newLinkedList();
                    for (TrelloList list : lists) {
                        listNames.add(list.getName());
                    }
                    try {
                        long view = boardManager.createRapidBoard(jiraProject, listNames);
                        TrelloImporterDataBean.this.rapidBoards.put(jiraProject.getName(), view);
                    }
                    catch (BoardManager.DependencyNotPresentException e) {
                        log.warn((Object)("Error setting up Trello Rapid Board for project " + project.getKey()), (Throwable)e);
                    }
                    catch (BoardManager.BoardCreationException e) {
                        String error = TrelloImporterDataBean.this.client.getI18nHelper().getText("com.atlassian.jira.plugins.importer.trello.trelloImporterDataBean.error.createTrelloRapidBord", project.getKey(), e.getLocalizedMessage());
                        log.error((Object)error);
                        if (importLog != null) {
                            importLog.fail((Throwable)e, error, new Object[0]);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            public void afterIssueCreated(ExternalIssue externalIssue, Issue jiraIssue) {
                if (TrelloImporterDataBean.this.boardManagerAccessor.getBoardManager() != null) {
                    BoardManager boardManager = TrelloImporterDataBean.this.boardManagerAccessor.getBoardManager();
                    MutableIssue mutableJiraIssue = TrelloImporterDataBean.this.issueManager.getIssueObject(jiraIssue.getId());
                    mutableJiraIssue.setCustomFieldValue(boardManager.getRankField(), (Object)this.rank++);
                }
            }
        };
    }
}

