/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.trello;

import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.JiraDataImporter;
import com.atlassian.jira.plugins.importer.trello.TrelloImportProcessBean;
import com.atlassian.jira.plugins.importer.trello.TrelloImporterClient;
import com.atlassian.jira.plugins.importer.trello.TrelloImporterClientBuilder;
import com.atlassian.jira.plugins.importer.trello.TrelloImporterConfigBean;
import com.atlassian.jira.plugins.importer.trello.TrelloImporterDataBean;
import com.atlassian.jira.plugins.importer.trello.agileutils.BoardManagerAccessor;
import com.atlassian.jira.plugins.importer.trello.web.TrelloProjectSelectionPage;
import com.atlassian.jira.plugins.importer.trello.web.TrelloSetupPage;
import com.atlassian.jira.plugins.importer.web.AbstractImporterController;
import com.atlassian.jira.plugins.importer.web.AbstractSetupPage;
import com.atlassian.jira.plugins.importer.web.ConfigFileHandler;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;

public class TrelloImporterController
extends AbstractImporterController {
    private static final String IMPORT_SESSION_ATTRIBUTE_NAME = "issue.importer.jira.trello.import.bean";
    private static final String IMPORT_ID = "TrelloImporter";
    private final ConfigFileHandler configFileHandler;
    private final TrelloImporterClientBuilder trelloImporterClientBuilder;
    private final BoardManagerAccessor boardManagerAccessor;
    private final GlobalPermissionManager globalPermissionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final JiraDataImporter jiraDataImporter;
    private final IssueManager issueManager;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private TrelloImporterClient trelloImporterClient;

    public TrelloImporterController(@ComponentImport JiraDataImporter importer, @ComponentImport ConfigFileHandler configFileHandler, TrelloImporterClientBuilder trelloImporterClientBuilder, BoardManagerAccessor boardManagerAccessor, @ComponentImport GlobalPermissionManager globalPermissionManager, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport JiraDataImporter jiraDataImporter, @ComponentImport IssueManager issueManager, @ComponentImport SoyTemplateRenderer soyTemplateRenderer) {
        super(importer, IMPORT_SESSION_ATTRIBUTE_NAME, IMPORT_ID);
        this.configFileHandler = configFileHandler;
        this.trelloImporterClientBuilder = trelloImporterClientBuilder;
        this.boardManagerAccessor = boardManagerAccessor;
        this.globalPermissionManager = globalPermissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.jiraDataImporter = jiraDataImporter;
        this.issueManager = issueManager;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    public boolean createImportProcessBean(AbstractSetupPage abstractSetupPage) {
        if (abstractSetupPage.invalidInput()) {
            return false;
        }
        TrelloSetupPage trelloSetupPage = (TrelloSetupPage)abstractSetupPage;
        TrelloImporterConfigBean configBean = new TrelloImporterConfigBean();
        this.trelloImporterClient = this.trelloImporterClientBuilder.build(configBean);
        configBean.setClient(this.trelloImporterClient);
        if (!this.configFileHandler.populateFromConfigFile((AbstractSetupPage)trelloSetupPage, (AbstractConfigBean)configBean)) {
            return false;
        }
        TrelloImportProcessBean importProcessBean = new TrelloImportProcessBean();
        importProcessBean.setConfigBean((AbstractConfigBean)configBean);
        this.storeImportProcessBeanInSession(importProcessBean);
        return true;
    }

    public ImportDataBean createDataBean() throws Exception {
        TrelloImportProcessBean importProcessBean = (TrelloImportProcessBean)this.getImportProcessBeanFromSession();
        return new TrelloImporterDataBean(importProcessBean, this.boardManagerAccessor, this.globalPermissionManager, this.jiraAuthenticationContext, this.jiraDataImporter, this.issueManager, this.soyTemplateRenderer);
    }

    public List<String> getSteps() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object[])new String[]{TrelloSetupPage.class.getSimpleName(), TrelloProjectSelectionPage.class.getSimpleName()});
        return builder.build();
    }

    public List<String> getStepNameKeys() {
        return Lists.newArrayList((Object[])new String[]{"com.atlassian.jira.plugins.importer.trello.step.setup", "com.atlassian.jira.plugins.importer.trello.step.projectMapping"});
    }
}

