/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.trello;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.config.ResolutionManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.trello.TrelloImporterConfigBean;
import com.atlassian.jira.plugins.importer.trello.WorkflowHelper;
import com.atlassian.jira.plugins.importer.trello.agileutils.BoardManagerAccessor;
import com.atlassian.jira.plugins.importer.trello.fetch.TrelloApiImpl;
import com.atlassian.jira.plugins.importer.trello.fetch.TrelloParser;
import com.atlassian.jira.plugins.importer.trello.model.Board;
import com.atlassian.jira.plugins.importer.trello.model.Card;
import com.atlassian.jira.plugins.importer.trello.model.User;
import com.atlassian.jira.plugins.importer.trello.transformers.BoardTransformer;
import com.atlassian.jira.plugins.importer.trello.transformers.CardTransformer;
import com.atlassian.jira.plugins.importer.trello.transformers.UserTransformer;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.type.ProjectTypeManager;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.scribe.model.Token;
import org.scribe.oauth.OAuthService;

public class TrelloImporterClient {
    private static final String SOFTWARE_TYPE = "software";
    private static final String CORE_TYPE = "business";
    private final I18nHelper i18nHelper;
    private final ApplicationProperties applicationProperties;
    private final PriorityManager priorityManager;
    private final ResolutionManager resolutionManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final ProjectManager projectManager;
    private final ConstantsManager constantsManager;
    private final BoardManagerAccessor boardManagerAccessor;
    private final BoardTransformer boardTransformer;
    private final TrelloApiImpl api;
    private final TrelloParser parser;

    public TrelloImporterClient(I18nHelper i18nHelper, ApplicationProperties applicationProperties, PriorityManager priorityManager, ResolutionManager resolutionManager, IssueTypeSchemeManager issueTypeSchemeManager, ProjectManager projectManager, ConstantsManager constantsManager, BoardManagerAccessor boardManagerAccessor, WorkflowHelper workflowHelper, TrelloImporterConfigBean configBean) {
        this.i18nHelper = i18nHelper;
        this.applicationProperties = applicationProperties;
        this.priorityManager = priorityManager;
        this.resolutionManager = resolutionManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.projectManager = projectManager;
        this.constantsManager = constantsManager;
        this.boardManagerAccessor = boardManagerAccessor;
        this.boardTransformer = new BoardTransformer(configBean, workflowHelper);
        this.api = new TrelloApiImpl(i18nHelper);
        this.parser = new TrelloParser(i18nHelper);
    }

    public List<String> getAllProjectNames() {
        User currentUser = this.parser.getUser(this.api.getCurrentUser());
        List<Board> boards = this.parser.getBoards(this.api.getBoards(currentUser));
        LinkedList projectNames = Lists.newLinkedList();
        for (Board board : boards) {
            projectNames.add(board.getName());
        }
        return projectNames;
    }

    public Collection<ExternalProject> getAllProjects(ImportLogger log) {
        User currentUser = this.parser.getUser(this.api.getCurrentUser());
        List<Board> boards = this.parser.getBoards(this.api.getBoards(currentUser));
        return Collections2.transform(boards, (Function)this.boardTransformer);
    }

    public Set<ExternalUser> getUsers(Iterable<ExternalProject> selectedProjects) {
        HashSet result = Sets.newHashSet();
        for (ExternalProject project : selectedProjects) {
            result.addAll(Collections2.transform(this.parser.getUsers(this.api.getUsers(project.getId())), (Function)new UserTransformer()));
        }
        return result;
    }

    public long getTotalIssues(Iterable<ExternalProject> selectedProjects, ImportLogger importLogger) {
        int totalIssues = 0;
        for (ExternalProject project : selectedProjects) {
            totalIssues += this.parser.getCards(this.api.getCards(project.getId())).size();
        }
        return totalIssues;
    }

    public Iterator<ExternalIssue> getIssuesIterator(ExternalProject project, ImportLogger logger) {
        List<Card> cardList = this.parser.getCards(this.api.getCards(project.getId()));
        Collections.sort(cardList);
        CardTransformer cardTransformer = new CardTransformer(this, logger, this.applicationProperties, this.priorityManager, this.resolutionManager, project, this.issueTypeSchemeManager, this.projectManager, this.constantsManager, this.boardManagerAccessor.getBoardManager());
        return Collections2.transform(cardList, (Function)cardTransformer).iterator();
    }

    public void setAccessToken(Token accessToken) {
        this.api.setAccessToken(accessToken);
    }

    public OAuthService getService() {
        return this.api.getService();
    }

    public void setService(OAuthService service) {
        this.api.setService(service);
    }

    public TrelloApiImpl getApi() {
        return this.api;
    }

    public TrelloParser getParser() {
        return this.parser;
    }

    public I18nHelper getI18nHelper() {
        return this.i18nHelper;
    }

    public static String getDefaultProjectType() {
        ProjectTypeManager projectTypeManager = (ProjectTypeManager)ComponentAccessor.getComponent(ProjectTypeManager.class);
        return projectTypeManager.getAllAccessibleProjectTypes().stream().anyMatch(type -> SOFTWARE_TYPE.equalsIgnoreCase(type.getKey().getKey())) ? SOFTWARE_TYPE : CORE_TYPE;
    }
}

