/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.redmine.web;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.plugins.importer.extensions.ImporterController;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.AbstractSetupPage;
import com.atlassian.jira.plugins.importer.web.ConfigFileHandler;
import com.atlassian.jira.plugins.importer.web.RemoteSiteImporterSetupPage;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;

public class RedmineSetupPage
extends AbstractSetupPage
implements RemoteSiteImporterSetupPage {
    private final ConfigFileHandler configFileHandler;
    private String siteUsername;
    private String sitePassword;
    private String siteUrl;

    public RedmineSetupPage(@ComponentImport UsageTrackingService usageTrackingService, @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport ConfigFileHandler configFileHandler, @ComponentImport EventPublisher eventPublisher) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor, eventPublisher);
        this.configFileHandler = configFileHandler;
    }

    protected void doValidation() {
        if (this.isPreviousClicked()) {
            return;
        }
        super.doValidation();
        this.configFileHandler.verifyConfigFileParam((AbstractSetupPage)this);
    }

    public String doDefault() throws Exception {
        if (!this.isAdministrator()) {
            return "denied";
        }
        ImporterController controller = this.getController();
        if (controller == null) {
            return "restartimporterneeded";
        }
        return "input";
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        ImporterController controller = this.getController();
        if (controller == null) {
            return "restartimporterneeded";
        }
        if (!this.isPreviousClicked() && !controller.createImportProcessBean((AbstractSetupPage)this)) {
            return "input";
        }
        return super.doExecute();
    }

    public String getSiteUsername() {
        return this.siteUsername;
    }

    public void setSiteUsername(String siteUsername) {
        this.siteUsername = siteUsername;
    }

    public String getSitePassword() {
        return this.sitePassword;
    }

    public void setSitePassword(String sitePassword) {
        this.sitePassword = sitePassword;
    }

    public boolean isSiteUrlRequired() {
        return true;
    }

    public String getSiteUrl() {
        return this.siteUrl;
    }

    public void setSiteUrl(String siteUrl) {
        this.siteUrl = siteUrl;
    }

    public boolean getSiteCredentials() {
        return true;
    }

    public String getFormTitle() {
        return this.getText("jira-importer-plugin.wizard.connect.redmine.title");
    }

    public String getFormDescription() {
        return this.getText("jira-importer-plugin.wizard.connect.redmine.description");
    }

    public String getLoginLabel() {
        return this.getText("jira-importer-plugin.wizard.connect.redmine.login.label");
    }

    public String getPasswordLabel() {
        return this.getText("jira-importer-plugin.wizard.connect.redmine.password.label");
    }
}

