/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.redmine.transformer;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomFieldValue;
import com.atlassian.jira.plugins.importer.redmine.CustomFieldDefinition;
import com.atlassian.jira.plugins.importer.redmine.RedmineClient;
import com.atlassian.jira.plugins.importer.redmine.RedmineConfigBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.DateFieldFormat;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.taskadapter.redmineapi.bean.CustomField;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Redmine24CustomFieldTransformer {
    private final Logger log = LoggerFactory.getLogger(Redmine24CustomFieldTransformer.class);
    private final Map<Long, ExternalCustomField> definitions = Maps.newHashMap();
    private final RedmineConfigBean configBean;
    private final RedmineClient client;
    private Function<CustomFieldDefinition, ExternalCustomField> definitionTransformer = new Function<CustomFieldDefinition, ExternalCustomField>(){

        public ExternalCustomField apply(CustomFieldDefinition input) {
            ExternalCustomField cf;
            String name;
            String format = input.getFormat();
            String string = name = StringUtils.isNotEmpty((CharSequence)Redmine24CustomFieldTransformer.this.configBean.getFieldMapping(input.getName())) ? Redmine24CustomFieldTransformer.this.configBean.getFieldMapping(input.getName()) : input.getName();
            if ("string".equals(format)) {
                cf = ExternalCustomField.createText((String)("" + input.getId()), (String)name);
            } else if ("date".equals(format)) {
                cf = ExternalCustomField.createDatePicker((String)("" + input.getId()), (String)name);
            } else if ("text".equals(format)) {
                cf = ExternalCustomField.createFreeText((String)("" + input.getId()), (String)name);
            } else if ("int".equals(format)) {
                cf = ExternalCustomField.createNumber((String)("" + input.getId()), (String)name);
            } else if ("float".equals(format)) {
                cf = ExternalCustomField.createNumber((String)("" + input.getId()), (String)name);
            } else if ("link".equals(format)) {
                cf = new ExternalCustomField("" + input.getId(), name, "com.atlassian.jira.plugin.system.customfieldtypes:url", "com.atlassian.jira.plugin.system.customfieldtypes:textsearcher");
            } else if ("list".equals(format)) {
                cf = input.isMultiple() ? ExternalCustomField.createMultiSelect((String)("" + input.getId()), (String)name) : ExternalCustomField.createSelect((String)("" + input.getId()), (String)name);
            } else if ("user".equals(format)) {
                cf = new ExternalCustomField("" + input.getId(), name, "com.atlassian.jira.plugin.system.customfieldtypes:userpicker", "com.atlassian.jira.plugin.system.customfieldtypes:userpickergroupsearcher");
            } else if ("bool".equals(format)) {
                cf = ExternalCustomField.createRadio((String)("" + input.getId()), (String)name);
                cf.setValueSet((Collection)ImmutableList.of((Object)"Yes", (Object)"No"));
            } else {
                cf = "version".equals(format) ? (input.isMultiple() ? new ExternalCustomField("" + input.getId(), name, "com.atlassian.jira.plugin.system.customfieldtypes:multiversion", null) : new ExternalCustomField("" + input.getId(), name, "com.atlassian.jira.plugin.system.customfieldtypes:version", null)) : ExternalCustomField.createFreeText((String)("" + input.getId()), (String)name);
            }
            if (cf.getValueSet() == null || cf.getValueSet().size() <= 0) {
                cf.setValueSet(input.getPossibleValues());
            }
            Redmine24CustomFieldTransformer.this.definitions.put(input.getId(), cf);
            return cf;
        }
    };
    private Function<CustomField, ExternalCustomFieldValue> valueTransformer = new Function<CustomField, ExternalCustomFieldValue>(){

        public ExternalCustomFieldValue apply(CustomField input) {
            ExternalCustomField externalCustomField = (ExternalCustomField)Redmine24CustomFieldTransformer.this.definitions.get(input.getId());
            if (externalCustomField != null) {
                if (input.getValues() != null && input.getValues().size() > 0) {
                    return new ExternalCustomFieldValue(externalCustomField.getName(), externalCustomField.getTypeKey(), externalCustomField.getSearcherKey(), (Object)input.getValues());
                }
                return Redmine24CustomFieldTransformer.this.createValueFor(externalCustomField, input.getValue());
            }
            return new ExternalCustomFieldValue(input.getName(), "com.atlassian.jira.plugin.system.customfieldtypes:textarea", "com.atlassian.jira.plugin.system.customfieldtypes:textsearcher", (Object)input.getValue());
        }
    };

    public Redmine24CustomFieldTransformer(RedmineConfigBean configBean, RedmineClient redmineClient) {
        this.configBean = configBean;
        this.client = redmineClient;
    }

    private ExternalCustomFieldValue createValueFor(ExternalCustomField externalCustomField, String value) {
        Object preparedValue = value;
        if (value != null) {
            if (StringUtils.isNotBlank((CharSequence)value)) {
                if ("com.atlassian.jira.plugin.system.customfieldtypes:float".equals(externalCustomField.getTypeKey())) {
                    preparedValue = this.prepareNumber(value);
                } else if ("com.atlassian.jira.plugin.system.customfieldtypes:datepicker".equals(externalCustomField.getTypeKey())) {
                    preparedValue = this.prepareDate(value);
                } else if ("com.atlassian.jira.plugin.system.customfieldtypes:userpicker".equals(externalCustomField.getTypeKey())) {
                    preparedValue = this.prepareUser(value);
                }
            } else if ("com.atlassian.jira.plugin.system.customfieldtypes:radiobuttons".equals(externalCustomField.getTypeKey())) {
                preparedValue = "0".equals(value) ? "No" : "Yes";
            }
        }
        return new ExternalCustomFieldValue(externalCustomField.getName(), externalCustomField.getTypeKey(), externalCustomField.getSearcherKey(), preparedValue);
    }

    private Object prepareDate(String value) {
        try {
            DateFieldFormat dateFieldFormat = (DateFieldFormat)ComponentAccessor.getComponent(DateFieldFormat.class);
            return dateFieldFormat.formatDatePicker(new SimpleDateFormat("yyy-MM-hh").parse(value));
        }
        catch (ParseException e) {
            this.log.warn("Cannot parse date provided by Redmine: " + value, (Throwable)e);
            return value;
        }
    }

    private Object prepareUser(String value) {
        try {
            return this.client.getUserName(Integer.valueOf(value));
        }
        catch (NumberFormatException e) {
            this.log.warn("Cannot parse user id provided by redmine (" + value + ")", (Throwable)e);
            return value;
        }
    }

    private Object prepareNumber(String value) {
        try {
            Locale jiraUserLocale = ((JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class)).getI18nHelper().getLocale();
            Number sourceNumber = NumberFormat.getInstance(Locale.US).parse(value);
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(jiraUserLocale);
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.setGroupingUsed(false);
            decimalFormat.setMinimumFractionDigits(0);
            decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
            return decimalFormat.format(sourceNumber);
        }
        catch (ParseException e) {
            this.log.warn("Redmine importer cannot format number: " + value);
            return value;
        }
    }

    public Function<CustomFieldDefinition, ExternalCustomField> getDefinitionTransformer() {
        return this.definitionTransformer;
    }

    public Function<CustomField, ExternalCustomFieldValue> getValueTransformer() {
        return this.valueTransformer;
    }
}

