/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.redmine.transformer;

import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingHelper;
import com.atlassian.jira.plugins.importer.redmine.RedmineConfigBean;
import com.google.common.base.Function;
import com.taskadapter.redmineapi.bean.Project;

public class ProjectTransformer
implements Function<Project, ExternalProject> {
    private final RedmineConfigBean redmineConfigBean;

    public ProjectTransformer(RedmineConfigBean redmineConfigBean) {
        this.redmineConfigBean = redmineConfigBean;
    }

    public ExternalProject apply(Project input) {
        String projectName = input.getName();
        ExternalProject externalProject = new ExternalProject();
        externalProject.setDescription(input.getDescription());
        externalProject.setUrl(input.getHomepage());
        externalProject.setId(input.getId() == null ? null : input.getId().toString());
        externalProject.setExternalName(projectName);
        externalProject.setKey(this.redmineConfigBean.getProjectKey(projectName));
        externalProject.setName(this.redmineConfigBean.getProjectName(projectName));
        externalProject.setLead(this.redmineConfigBean.getProjectLead(projectName));
        ValueMappingHelper helper = this.redmineConfigBean.getValueMappingHelper();
        if (helper.isWorkflowSchemeDefined()) {
            externalProject.setWorkflowSchemeName(helper.getWorkflowSchemeName());
        }
        return externalProject;
    }
}

