/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.redmine.transformer;

import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.redmine.RedmineClient;
import com.atlassian.jira.plugins.importer.redmine.RedmineRemoteException;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.taskadapter.redmineapi.bean.Attachment;
import java.io.File;

public class AttachmentTransformer
implements Function<Attachment, ExternalAttachment> {
    private final RedmineClient redmineClient;
    private final ImportLogger logger;

    public AttachmentTransformer(RedmineClient redmineClient, ImportLogger logger) {
        this.logger = logger;
        this.redmineClient = (RedmineClient)Preconditions.checkNotNull((Object)redmineClient);
    }

    public ExternalAttachment apply(Attachment input) {
        File file;
        try {
            file = this.redmineClient.getAttachmentContent(input, this.logger);
        }
        catch (RedmineRemoteException e) {
            this.logger.warn((Throwable)e, "Cannot download attachment with name: " + input.getFileName(), new Object[0]);
            return null;
        }
        ExternalAttachment externalAttachment = new ExternalAttachment(input.getFileName(), file, input.getCreatedOn());
        externalAttachment.setAttacher(this.redmineClient.getUserName(input.getAuthor()));
        externalAttachment.setDescription(input.getDescription());
        return externalAttachment;
    }
}

