/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.redmine.mapping;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.plugins.importer.imports.config.AbstractValueMappingDefinition;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingDefinition;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingEntry;
import com.atlassian.jira.plugins.importer.redmine.RedmineConfigBean;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public class IssueTrackerValueMappingDefinition
implements ValueMappingDefinition {
    public static final String TRACKER_FIELD_NAME = "tracker";
    private final RedmineConfigBean redmineConfigBean;
    private final ConstantsManager constantsManager;

    public IssueTrackerValueMappingDefinition(RedmineConfigBean redmineConfigBean, ConstantsManager constantsManager) {
        this.redmineConfigBean = redmineConfigBean;
        this.constantsManager = constantsManager;
    }

    public String getExternalFieldId() {
        return TRACKER_FIELD_NAME;
    }

    public String getDescription() {
        return null;
    }

    public Set<String> getDistinctValues() {
        return Sets.newHashSet(this.redmineConfigBean.getRedmineClient().getTrackers());
    }

    public String getJiraFieldId() {
        return "issuetype";
    }

    public Collection<ValueMappingEntry> getTargetValues() {
        return new ArrayList<ValueMappingEntry>(Collections2.transform((Collection)this.constantsManager.getAllIssueTypeObjects(), (Function)new AbstractValueMappingDefinition.IssueConstantToValueMapping()));
    }

    public Collection<ValueMappingEntry> getDefaultValues() {
        return new ImmutableList.Builder().add((Object[])new ValueMappingEntry[]{new ValueMappingEntry("Bug", Integer.valueOf(1)), new ValueMappingEntry("Feature", Integer.valueOf(2)), new ValueMappingEntry("Support", Integer.valueOf(3))}).build();
    }

    public boolean canBeBlank() {
        return false;
    }

    public boolean canBeImportedAsIs() {
        return false;
    }

    public boolean canBeCustom() {
        return false;
    }

    public boolean isMandatory() {
        return true;
    }
}

