/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.redmine.manager;

import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.internal.comm.Communicator;
import com.taskadapter.redmineapi.internal.comm.ContentHandler;
import com.taskadapter.redmineapi.internal.comm.redmine.RedmineAuthenticator;
import java.io.Closeable;
import java.io.IOException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.SystemDefaultHttpClient;

public class RedmineCommunicator
extends RedmineAuthenticator<HttpResponse>
implements Closeable {
    private static final String REDMINE_CHARSET = "UTF-8";
    private final HttpCommunicator redmineCommunicator;

    public RedmineCommunicator() {
        this(new HttpCommunicator(), REDMINE_CHARSET);
    }

    private RedmineCommunicator(HttpCommunicator httpCommunicator, String charset) {
        super((Communicator)httpCommunicator, charset);
        this.redmineCommunicator = httpCommunicator;
    }

    @Override
    public void close() throws IOException {
        this.redmineCommunicator.close();
    }

    private static class HttpCommunicator
    implements Communicator<HttpResponse>,
    Closeable {
        HttpClient httpClient = new SystemDefaultHttpClient();

        private HttpCommunicator() {
        }

        public <R> R sendRequest(HttpRequest request, ContentHandler<HttpResponse, R> contentHandler) throws RedmineException {
            HttpUriRequest uriRequest = (HttpUriRequest)request;
            try {
                return (R)contentHandler.processContent((Object)this.httpClient.execute(uriRequest));
            }
            catch (IOException e) {
                throw new RedmineException((Throwable)e);
            }
            catch (RuntimeException ex) {
                uriRequest.abort();
                throw ex;
            }
        }

        @Override
        public void close() throws IOException {
            this.httpClient.getConnectionManager().shutdown();
        }
    }
}

