/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.redmine;

import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean;
import com.atlassian.jira.plugins.importer.imports.importer.JiraDataImporter;
import com.atlassian.jira.plugins.importer.redmine.RedmineClient;
import com.atlassian.jira.plugins.importer.redmine.RedmineConfigBean;
import com.atlassian.jira.plugins.importer.redmine.RedmineDataBean;
import com.atlassian.jira.plugins.importer.redmine.RedmineRemoteException;
import com.atlassian.jira.plugins.importer.redmine.manager.JiraRedmineManagerFactory;
import com.atlassian.jira.plugins.importer.redmine.web.RedmineSetupPage;
import com.atlassian.jira.plugins.importer.web.AbstractImporterController;
import com.atlassian.jira.plugins.importer.web.AbstractSetupPage;
import com.atlassian.jira.plugins.importer.web.ConfigFileHandler;
import com.atlassian.jira.plugins.importer.web.ImportProcessBean;
import com.atlassian.jira.plugins.importer.web.ImporterCustomFieldsPage;
import com.atlassian.jira.plugins.importer.web.ImporterFieldMappingsPage;
import com.atlassian.jira.plugins.importer.web.ImporterLinksPage;
import com.atlassian.jira.plugins.importer.web.ImporterProjectMappingsPage;
import com.atlassian.jira.plugins.importer.web.ImporterValueMappingsPage;
import com.atlassian.jira.plugins.importer.web.RemoteSiteImporterSetupPage;
import com.atlassian.jira.plugins.importer.web.RemoteSiteValidator;
import com.atlassian.jira.plugins.importer.web.SiteConfiguration;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;

public class RedmineImporterController
extends AbstractImporterController {
    public static final String REDMINE_IMPORT_CONFIG_BEAN = "issue.importer.jira.redmine.import.bean";
    public static final String REDMINE_IMPORT_ID = "Redmine";
    private final ConfigFileHandler configFileHandler;

    public RedmineImporterController(@ComponentImport JiraDataImporter redmineImporter, @ComponentImport ConfigFileHandler configFileHandler) {
        super(redmineImporter, REDMINE_IMPORT_CONFIG_BEAN, REDMINE_IMPORT_ID);
        this.configFileHandler = configFileHandler;
    }

    public boolean createImportProcessBean(AbstractSetupPage setupPage) {
        RedmineSetupPage redmineSetupPage = (RedmineSetupPage)setupPage;
        this.validateRemoteSiteConnection(redmineSetupPage);
        if (redmineSetupPage.invalidInput()) {
            return false;
        }
        SiteConfiguration siteConfiguration = new SiteConfiguration(redmineSetupPage.getSiteUrl(), redmineSetupPage.getSiteCredentials(), redmineSetupPage.getSiteUsername(), redmineSetupPage.getSitePassword());
        RedmineConfigBean configBean = new RedmineConfigBean();
        RedmineClient redmineClient = this.getRedmineClient(redmineSetupPage, configBean);
        configBean.setRedmineClient(redmineClient);
        if (!this.configFileHandler.populateFromConfigFile((AbstractSetupPage)redmineSetupPage, (AbstractConfigBean)configBean)) {
            return false;
        }
        ImportProcessBean importProcessBean = new ImportProcessBean();
        importProcessBean.setUrlBean(siteConfiguration);
        importProcessBean.setConfigBean((AbstractConfigBean)configBean);
        this.storeImportProcessBeanInSession(importProcessBean);
        return true;
    }

    private RedmineClient getRedmineClient(RedmineSetupPage redmineSetupPage, RedmineConfigBean configBean) {
        JiraRedmineManagerFactory redmineManagerFactory = new JiraRedmineManagerFactory(redmineSetupPage.getSiteUrl(), redmineSetupPage.getSiteUsername(), redmineSetupPage.getSitePassword());
        return new RedmineClient(redmineManagerFactory, configBean, redmineSetupPage.getTimeTrackingEnabled());
    }

    private void validateRemoteSiteConnection(RedmineSetupPage redmineSetupPage) {
        if (new RemoteSiteValidator().validateConnection((RemoteSiteImporterSetupPage)redmineSetupPage)) {
            try {
                RedmineClient client = this.getRedmineClient(redmineSetupPage, null);
                client.login();
                client.logout();
            }
            catch (RedmineRemoteException e) {
                redmineSetupPage.addErrorMessage("Cannot login to Redmine site: " + e.getMessage());
            }
        }
    }

    public RedmineDataBean createDataBean() {
        RedmineConfigBean configBean = this.getConfigBeanFromSession();
        return new RedmineDataBean(configBean);
    }

    @Nullable
    RedmineConfigBean getConfigBeanFromSession() {
        ImportProcessBean importProcessBean = this.getImportProcessBeanFromSession();
        return importProcessBean != null ? (RedmineConfigBean)importProcessBean.getConfigBean() : null;
    }

    public List<String> getSteps() {
        return ImmutableList.builder().add((Object[])new String[]{RedmineSetupPage.class.getSimpleName(), ImporterProjectMappingsPage.class.getSimpleName(), ImporterCustomFieldsPage.class.getSimpleName(), ImporterFieldMappingsPage.class.getSimpleName(), ImporterValueMappingsPage.class.getSimpleName(), ImporterLinksPage.class.getSimpleName()}).build();
    }

    public List<String> getStepNameKeys() {
        return ImmutableList.builder().add((Object[])new String[]{"jira-importer-plugin.wizard.step.RedmineSetupPage", "jira-importer-plugin.wizard.step.ImporterProjectMappingsPage", "jira-importer-plugin.wizard.step.ImporterCustomFieldsPage", "jira-importer-plugin.wizard.step.ImporterFieldMappingsPage", "jira-importer-plugin.wizard.step.ImporterValueMappingsPage", "jira-importer-plugin.wizard.step.ImporterLinksPage"}).build();
    }
}

