/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.redmine;

import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComponent;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalLink;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.external.beans.ExternalVersion;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean2;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.redmine.RedmineConfigBean;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class RedmineDataBean
extends AbstractDataBean<RedmineConfigBean> {
    public static final String UNUSED_USERS_GROUP = "redmine-import-unused-users";

    protected RedmineDataBean(RedmineConfigBean configBean) {
        super((AbstractConfigBean2)configBean);
    }

    public Set<ExternalUser> getRequiredUsers(Collection<ExternalProject> projects, ImportLogger importLogger) {
        final Set<String> userIdsForProjects = ((RedmineConfigBean)this.configBean).getRedmineClient().getUserIdsForProjects(projects, importLogger);
        return Sets.filter(this.getAllUsers(importLogger), (Predicate)new Predicate<ExternalUser>(){

            public boolean apply(ExternalUser input) {
                return userIdsForProjects.contains(input.getId());
            }
        });
    }

    public Set<ExternalUser> getAllUsers(ImportLogger log) {
        return Sets.newHashSet(((RedmineConfigBean)this.configBean).getRedmineClient().getAllUsers(log));
    }

    public Set<ExternalProject> getAllProjects(ImportLogger log) {
        return Sets.newHashSet(((RedmineConfigBean)this.configBean).getRedmineClient().getAllProjects(log));
    }

    public Collection<ExternalVersion> getVersions(ExternalProject externalProject, ImportLogger importLogger) {
        return Lists.newArrayList(((RedmineConfigBean)this.configBean).getRedmineClient().getVersions(externalProject.getId(), importLogger));
    }

    public Collection<ExternalComponent> getComponents(ExternalProject externalProject, ImportLogger importLogger) {
        return Lists.newArrayList(((RedmineConfigBean)this.configBean).getRedmineClient().getComponents(externalProject.getId(), importLogger));
    }

    public Iterator<ExternalIssue> getIssuesIterator(ExternalProject externalProject, ImportLogger importLogger) {
        return this.getIssues(externalProject, importLogger).iterator();
    }

    public void cleanUp() {
        ((RedmineConfigBean)this.configBean).getRedmineClient().logout();
    }

    public String getIssueKeyRegex() {
        return null;
    }

    public Collection<ExternalAttachment> getAttachmentsForIssue(ExternalIssue externalIssue, ImportLogger log) {
        return Lists.newArrayList(((RedmineConfigBean)this.configBean).getRedmineClient().getAttachmentsForIssue(externalIssue.getExternalId(), log));
    }

    public Collection<ExternalLink> getLinks(ImportLogger log) {
        return ((RedmineConfigBean)this.configBean).getRedmineClient().getLinks(this.getSelectedProjects(log), log);
    }

    public long getTotalIssues(Set<ExternalProject> selectedProjects, ImportLogger log) {
        int total = 0;
        for (ExternalProject selectedProject : selectedProjects) {
            total += Iterables.size(this.getIssues(selectedProject, log));
        }
        return total;
    }

    private Iterable<ExternalIssue> getIssues(ExternalProject selectedProject, ImportLogger log) {
        return ((RedmineConfigBean)this.configBean).getRedmineClient().getIssues(selectedProject.getId(), log);
    }

    public String getUnusedUsersGroup() {
        return UNUSED_USERS_GROUP;
    }
}

