/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.redmine;

import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingDefinition;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingDefinitionsFactory;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingHelper;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingHelperImpl;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean2;
import com.atlassian.jira.plugins.importer.redmine.RedmineClient;
import com.atlassian.jira.plugins.importer.redmine.mapping.IssueTrackerValueMappingDefinition;
import com.atlassian.jira.plugins.importer.redmine.mapping.PriorityValueMappingDefinition;
import com.atlassian.jira.plugins.importer.redmine.mapping.StatusValueMappingDefinition;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class RedmineConfigBean
extends AbstractConfigBean2 {
    private RedmineClient redmineClient;

    public List<String> getExternalProjectNames() {
        return Lists.newArrayList(this.redmineClient.getAllExternalProjectNames());
    }

    public List<ExternalCustomField> getCustomFields() {
        return Lists.newArrayList(this.redmineClient.getCustomFields());
    }

    public RedmineClient getRedmineClient() {
        return this.redmineClient;
    }

    public void setRedmineClient(RedmineClient redmineClient) {
        Preconditions.checkNotNull((Object)redmineClient);
        this.redmineClient = redmineClient;
    }

    public List<String> getLinkNamesFromDb() {
        ArrayList linksNames = Lists.newArrayList(this.redmineClient.getLinkNames());
        linksNames.add("parent");
        return linksNames;
    }

    public ValueMappingHelper initializeValueMappingHelper() {
        ValueMappingDefinitionsFactory mappingDefinitionFactory = new ValueMappingDefinitionsFactory(){

            public List<ValueMappingDefinition> createMappingDefinitions(ValueMappingHelper valueMappingHelper) {
                ArrayList mappings = Lists.newArrayList();
                mappings.add(new StatusValueMappingDefinition(RedmineConfigBean.this));
                mappings.add(new IssueTrackerValueMappingDefinition(RedmineConfigBean.this, RedmineConfigBean.this.getConstantsManager()));
                mappings.add(new PriorityValueMappingDefinition(RedmineConfigBean.this, RedmineConfigBean.this.getConstantsManager()));
                return mappings;
            }
        };
        return new ValueMappingHelperImpl(this.getWorkflowSchemeManager(), this.getWorkflowManager(), mappingDefinitionFactory, this.getConstantsManager());
    }
}

