/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.redmine;

import java.util.Set;

public class CustomFieldDefinition {
    private final boolean required;
    private final String name;
    private final String defaultValue;
    private final long id;
    private final String format;
    private final boolean multiple;
    private final Set<String> possibleValues;

    public boolean isRequired() {
        return this.required;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public long getId() {
        return this.id;
    }

    public String getFormat() {
        return this.format;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public Set<String> getPossibleValues() {
        return this.possibleValues;
    }

    private CustomFieldDefinition(boolean required, String name, String defaultValue, long id, String format, boolean multiple, Set<String> possibleValues) {
        this.required = required;
        this.name = name;
        this.defaultValue = defaultValue;
        this.id = id;
        this.format = format;
        this.multiple = multiple;
        this.possibleValues = possibleValues;
    }

    public static class Builder {
        private boolean required;
        private String name;
        private String defaultValue;
        private long id;
        private String format;
        private boolean multiple;
        private Set<String> possibleValues;

        public Builder setRequired(boolean required) {
            this.required = required;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder setId(long id) {
            this.id = id;
            return this;
        }

        public Builder setFormat(String format) {
            this.format = format;
            return this;
        }

        public Builder setMultiple(boolean multiple) {
            this.multiple = multiple;
            return this;
        }

        public Builder setPossibleValues(Set<String> possibleValues) {
            this.possibleValues = possibleValues;
            return this;
        }

        public CustomFieldDefinition createCustomFieldDefinition() {
            return new CustomFieldDefinition(this.required, this.name, this.defaultValue, this.id, this.format, this.multiple, this.possibleValues);
        }
    }
}

