(function() {

    jQuery.namespace('importer');


    /**
     * Gives a JSON interface to a &lt;select list&gt;. Allowing you to add elements via JSON descriptors. It also
     * provides utility methods to retrieve collections of elements as JSON, for example selected options.
     *
     * @constructor AJS.SelectModel
     * @extends AJS.Control
     */
     /**
     * Gives a JSON interface to a &lt;select list&gt;. Allowing you to add elements via JSON descriptors. It also
     * provides utility methods to retrieve collections of elements as JSON, for example selected options.
     *
     * @constructor AJS.SelectModel
     * @extends AJS.Control
     */
    var LegacySelectModel = AJS.SelectModel.extend({


        /**
         * Appends options to select  using an array of JSON descriptors. ONLY options that have not already been defined.
         *
         * <pre>
         * // structure
         * [
         *  {
         *      label: "History Search",
         *      type: "optgroup",
         *      weight: 0, // order in list (starts from 0)
         *      options: [
         *          {
         *              icon: "/jira/images/icons/issue_subtask.gif",
         *              label: "HSP-2 - test,
         *              type: "option"
         *          },
         *          {
         *              icon: "/jira/images/icons/issue_subtask.gif",
         *              label: "HSP-1 - I am a iest Issue,
         *              type: "option"
         *          }
         *      ]
         *  },
         *  {
         *      label: "Current Search",
         *      type: "optgroup"
         *      weight: 1, // order in list (starts from 0)
         *      options: [
         *          {
         *              icon: "/jira/images/icons/issue_subtask.gif",
         *              label: "HSP-2 - test,
         *              type: "option"
         *          },
         *          {
         *              icon: "/jira/images/icons/issue_subtask.gif",
         *              label: "HSP-1 - I am a iest Issue,
         *              type: "option"
         *          }
         *      ]
         *   }
         * ]
         * </pre>
         *
         * @method appendOptionsFromJSON
         * @param {Array} optionDescriptors - JSON tree describing options and optgroups to be appended
         *
         * @return true if the model is updated in any way
         */
        appendOptionsFromJSON: function (optionDescriptors) {

            var modified = false;

            for (var i = 0, len = optionDescriptors.length; i < len; i++) {

                var descriptor = optionDescriptors[i];
                if (descriptor instanceof AJS.GroupDescriptor) {

                    // Ensure an <optgroup> exists to match this GroupDescriptor
                    this._appendGroup(descriptor);
                    modified = true;

                } else if (descriptor instanceof AJS.ItemDescriptor) {

                    // Ensure an <option> exists to match this ItemDescriptor
                    if (!this._getOptionItem(descriptor).length) {
                        this._render("option", descriptor).appendTo(this.$element);
                        modified = true;
                    }
                }
            }

            return modified;
        },

         /**
          * Return the option with an identical value to our descriptor, if present in the provided context.
          *
          * @method _getOptionItem
          * @private
          * @param {Object} descriptor - JSON object decribing option
          * @param {jQuery | HTMLElement} ctx - Context to search for option. If not provided will search entire select
          * @return {jQuery}
          */
         _getOptionItem: function (descriptor, ctx) {

             ctx = ctx || this.$element;
             var value = descriptor.value().replace(/"/g, '\\"');

             return ctx.find('option[value="' + value + '"]');
         },


         /**
          * Return the optiongroup with an identical label to our descriptor, if present in the provided context.
          *
          * @method _getOptionGroup
          * @private
          * @param  {Object} descriptor - JSON object decribing optgroup
          * @return {jQuery}
          */
         _getOptionGroup: function (descriptor, ctx) {

             ctx = ctx || this.$element;
             return ctx.find("optgroup").filter(function () {
                 return this.id === descriptor.id() || AJS.$(this).attr("label") === descriptor.label();
             });
         },


         _appendGroup: function (descriptor) {

            var optgroup = this._getOptionGroup(descriptor);
            var container = this.$element;
            var replaceItems = descriptor.replace();

            // 1. Either clean up an existing <optgroup> or create one.
            if (optgroup.length) {
                if (replaceItems) {
                    optgroup.find("option:not(:selected)").remove();        // clears *unused* options, see NOTE 1 below
                }
            } else {
                optgroup = this._render("optgroup", descriptor);
            }
            optgroup.data("descriptor", descriptor);

            // 2. Update or create <option> items inside the group. If item scope for this group is not the default, items
            //    will only be added to this group if they don't exist in the specified scope.
            var items = descriptor.items();
            var itemScope = (descriptor.uniqueItemScope() == 'container') ? container : optgroup;
            for (var i = 0, len = items.length; i < len; i++) {

                var optDescriptor = items[i];
                var option = this._getOptionItem(optDescriptor, itemScope);
                if (!option.length) {
                    optgroup.append(this._render("option", optDescriptor));
                } else if (!replaceItems) {
                    // NOTE 1 - selected options will therefore not be updated if replaceItemsInGroup is true.
                    option.data("descriptor", optDescriptor);
                }
            }

            // 3. Check to see if this Group has a weight and should go somewhere specific in the container.
            var target;
            var weight = descriptor.weight();
            if (typeof weight !== "undefined") {
                // This Group wants to go into the container at a particular index... see if something else
                // is in the way.
                target = container.children()[weight];
                if (target === optgroup[0]) {
                    // This Group already exists in the container at the correct index - leave it there.
                    return;
                }
            }

            // 4. Either put the new <optgroup> in its place or at the bottom of the container.
            if (target) {
                // There's another group or item where this Group wants to go - insert to bump it down.
                optgroup.insertBefore(target);
            } else {
                optgroup.appendTo(container);
            }
        }
    });




    var EXISTING_CUSTOM_FIELD = 'existingCustomField';

	importer.displayCommentHelp = function() {
		var commentMapping = false;

		AJS.$("SELECT.importField").each(function() {
			if (AJS.$(this).val() == "comment") {
				commentMapping = true;
			}
		});

		AJS.$("#comment-help").toggle(commentMapping);
	};

	importer.displayExistingCustomFieldHelp = function() {
		var cfMapping = false;

		AJS.$("SELECT.importField").each(function() {
			if (AJS.$(this).val() == EXISTING_CUSTOM_FIELD) {
				cfMapping = true;
			}
		});

		AJS.$("#existing-custom-field-help").toggle(cfMapping);
	};

	// Toggles
    importer.toggle = new JIRA.ToggleBlock({
        blockSelector: ".toggle-wrap",
        triggerSelector: ".mod-header h3",
        cookieCollectionName: "jim-block-states",
        originalTargetIgnoreSelector: "a"
    });

	importer.NextButtonAwareSingleSelect = AJS.SingleSelect.extend({
		submitForm: function () {
			if (!this.suggestionsVisible) {
            	this.handleFreeInput();
				AJS.$("#nextButton:enabled").click();
        	}
		},

		init: function (options) {
			this._super(options);
            this.model.$element.removeAttr("multiple").unbind();
            this.model = new LegacySelectModel({
                element:this.model.$element,
                removeOnUnSelect: this.options.removeOnUnSelect
            });
		},

		_createFurniture: function(disabled) {
			this._super(disabled);
			if (this.options.overlabel && !this.$overlabel) {
				this.$overlabel = this._render("overlabel").insertBefore(this.$field);
				this.$overlabel.overlabel();
			}
		},

		updateOverlabel: function () {
			 if (this.$overlabel) {
                 if(this.$field.val() && this.$field.val() !== "") {
//                     fix overlabel not working when using dropdown to select entry
                     this.$overlabel.addClass("hidden");
                 } else if (!this.$field.is(":focus")) {
                     this.$overlabel.removeClass("hidden");
                 }
			 }
		},

		enable: function () {
			if (this.$field.attr("disabled")) {
				this.$field.removeAttr("disabled");
				this._assignEvents("dropdownAndLoadingIcon", this.$dropDownIcon);
				this._super();
			}
		},

		disable: function () {
			if (!this.$field.attr("disabled")) {
				this.$field.attr("disabled", "disabled");
				this._unassignEvents("dropdownAndLoadingIcon", this.$dropDownIcon);
				this._super();
			}
		},

		selectByKey: function (key) {
			var descriptor = key && this.model.getDescriptor(key);
			if (descriptor) {
				this.setSelection(descriptor);
			} else {
				this.$field.val("");
				this.clearSelection();
			}
		}
	});

    AJS.$(document).ready(function() {
        // fix for https://jira.atlassian.com/browse/JRA-27131, studio specific code
        AJS.$("#menu_section_studio_import_export_section + ul > li > a[href='#']").each(function(idx, elem) {AJS.$(elem).css("cursor", "default").parent().css("margin-left", "33px");})
    });

}());