;require([
    "jim/general/view/importer-chocolate",
    "jim/general/ImporterClicked",
    "jim/general/OnboardingAnalytics",
    "jquery",
    "backbone"
], function(
    ImporterChocolate,
    ImporterClicked,
    Analytics,
    $,
    Backbone
) {
    $(function() {
        var analytics = new Analytics();

        var importers = WRM.data.claim('jira-importers-plugins:importers');
        var importersChocolate = new ImporterChocolate({
            collection: new Backbone.Collection(importers),
            el: '.target-importers'
        });
        importersChocolate.on('importer-clicked', function (model) {
            new ImporterClicked({
                model: model
            });

        });
        importersChocolate.render();

        $('#itemNoneOfThese').on('click', function() {
            analytics.pushEvent("none.of.these", { fromOnboarding: true });
        });

        analytics.pushEvent("visited");
    });
});