(function () {
    AJS.InlineAttach.AjaxPresenter.DEFAULT_URL = contextPath + "/rest/jira-importers-plugin/1.0/AttachTemporaryFile";
    AJS.InlineAttach.AjaxPresenter.MAX_SELECTED_FILES = 1;


    AJS.InlineAttach.FormPresenter = AJS.InlineAttach.FormPresenter.extend({
        _createSubmitData:function () {
            var data = { atl_token:this.form.getAtlToken(), decorator:"none"};
            return data;
        }
    });

    AJS.InlineAttach.FormPresenter.DEFAULT_URL = contextPath + "/secure/admin/views/JIMAttachTemporaryFile.jspa";

    fileAttachementControllJIM = {

        disableFileInput:function () {
            AJS.$(".jimFileInput").hide();


        },
        enableFileInput:function () {
            AJS.$("#uploadedFileSection").remove();
            AJS.$("#nextButton").attr('disabled', true);
            AJS.$(".jimFileInput").show();
            AJS.$("div.error").remove();

        }

    };

    AJS.InlineAttach.Form = AJS.InlineAttach.Form.extend({
        addTemporaryFileCheckbox:function (value, name, replaceObj, file) {
            var element = AJS.$("<div class='field-group' id='uploadedFileSection'/>")
            var label = AJS.$("<label>").text(jimMessages.label);
            var div = AJS.$("<div>").text(name);
            var href = AJS.$("<a>")
                .addClass("icon")
                .addClass("icon-delete")
                .click(fileAttachementControllJIM.enableFileInput);

            var check = AJS.$("<input type='hidden' name='filetoconvert'>").attr({
                "value":value

            }).hide();
            div.append(href);
            element.append(check).append(label).append(div);
            element.hide();

            this._replaceElement(element, replaceObj);
            AJS.$("#nextButton").removeAttr('disabled');

            var $encoding = AJS.$("#encoding");
            if ($encoding.length > 0 && AJS.$("#csvFile").length && $encoding.get(0).defaultValue == $encoding.val()) {
                AJS.$("#advanced .jim-csv-encoding-warning").remove();
                AJS.$.get(
                    contextPath + "/rest/jira-importers-plugin/1.0/AttachTemporaryFile/isAsciiOnly",
                    { attachmentId: AJS.$("#uploadedFileSection > input").val() }
                )
                    .done(function isAsciiOnlyCheckSuccessful(data) {
                        if (!data) {
                            AJS.$("#advanced")
                                .removeClass("collapsed")
                                .addClass("expanded")
                                .find(".jim-csv-encoding-warning")
                                    .remove()
                                    .end()
                                .find(".mod-content")
                                    .prepend(aui.message.warning({
                                        content: AJS.I18n.getText("jira-importer-plugin.csv.file.warning.encoding"),
                                        extraClasses: "jim-csv-encoding-warning"
                                    }));
                            AJS.$("#encoding").focus();
                        }
                    });
            }
            return this;
        },

        addProgress:function (file) {
            fileAttachementControllJIM.disableFileInput();
            return this._super(file);
        },

        addStaticProgress:function (file) {
            fileAttachementControllJIM.disableFileInput();
            return  this._super(file);
        },
        addError:function (error, replaceObj) {
            var $element;
            fileAttachementControllJIM.enableFileInput();
            $element = this._super(error, replaceObj);
            $element.children("div").addClass("error");
            return $element;
        }
    });
    AJS.InlineAttach.UploadProgress = AJS.InlineAttach.UploadProgress.extend({
        onCancel:function (callback) {

            return this._super(function () {
                callback.call(this);
                fileAttachementControllJIM.enableFileInput();
            });
        }
    });
    AJS.InlineAttach.UnknownProgress = AJS.InlineAttach.UnknownProgress.extend({
        onCancel:function (callback) {

            return this._super(function () {
                callback.call(this);
                fileAttachementControllJIM.enableFileInput();
            });
        }
    });
})();
