require([
    'jquery',
    'jira/flag'
], function(
    $,
    Flag
){
    $(function(){

        var jimBasePath = contextPath + '/rest/jira-importers-plugin/1.0';

        $('#export-trigger').on('click', function(e) {
            e.preventDefault();
            var jql = $('#export-jql').val();
            var date = $('#export-date').val();
            $.get(jimBasePath + '/demo/export', { jql: jql, baseDate: date })
                .done(function(sampleData) {
                    $('#export-output').val(JSON.stringify(sampleData, null, '\t'));
                }).fail(function(content){
                    var msg = content.status + " " + content.responseText;
                    Flag.showErrorMsg("Error", msg);
                });
        });

        $('#export-new-tab').on('click', function(e) {
            var jql = $('#export-jql').val();
            var date = $('#export-date').val();

            this.href = jimBasePath + '/demo/export?' + $.param({ jql: jql, baseDate: date });
        });

        $('#import-trigger').on('click', function(e) {
            e.preventDefault();
            var parameters = {
                key: $('#import-key').val(),
                name: $('#import-name').val(),
                lead: $('#import-lead').val(),
                template: $('#import-template').val()
            };
            var json = $('#import-json').val();
            $.ajax({
                url: jimBasePath + '/demo/create?' + $.param(parameters),
                type: 'PUT',
                data: json
            }).done(function (data) {
                Flag.showSuccessMsg(AJS.I18n.getText('common.words.done'), AJS.I18n.getText('jira-importer-plugin.demo-data.success'));
            }).fail(function (data) {
                Flag.showErrorMsg(AJS.I18n.getText('admin.common.words.error'), JSON.stringify(data, null, '\t'));
            });
        });

    });
});