AJS.$(function () {
    var DONT_MAP = "-jim-dont-map-this-project";
    var dontMapModel = new importer.ProjectModel({
        editable: false,
        key: DONT_MAP,
        name: AJS.I18n.getText("jira-importer-plugin.wizard.projectmappings.dont.import.this.project"),
        display: false
    });

    var originalprojectDetailsChange = importer.ProjectMappingView.prototype._projectDetailsChange;
    importer.ProjectMappingView.prototype._projectDetailsChange = function (changedModel) {
        var selectedDescriptor;
        var dontMapDescriptor = new AJS.ItemDescriptor({
            value: dontMapModel.get("key"),
            label: dontMapModel.get("name"),
            projectModel: dontMapModel
        });
        var groupDontMap = new AJS.GroupDescriptor({
            showLabel: false,
            type: "optgroup",
            weight: 0,
            items: [ dontMapDescriptor ]
        });

        this.projectSelect.model.appendOptionsFromJSON([groupDontMap]);

        originalprojectDetailsChange.apply(this, arguments);
        selectedDescriptor = this.projectSelect.getSelectedDescriptor();
        if (!selectedDescriptor && this.projectSelect.$container.parent().find(".error").length == 0) {
            this.projectSelect.setSelection(dontMapDescriptor);
        }
    };

    var SingleMappingView = Backbone.View.extend({
        initialize: function () {
            _.bindAll(this, "render");

            this.projectMappingView = new importer.ProjectMappingView(this.options).render();

            this.model.bind("change", this.render);
        },

        render: function () {
            this.projectMappingView.render();
            this.projectMappingView.iconRequired.hide();
            this.projectMappingView._enableProjectImport();
            return this;
        }
    });

    var projectsModel = new (Backbone.Collection.extend({
        model: importer.ProjectModel
    }));

    var mappingModel = new (Backbone.Collection.extend({
        model: importer.MappingModel
    }));

    projectsModel.reset(AJS.$("#projectMappings").data("projects-model"));
    mappingModel.reset(AJS.$("#projectMappings").data("mappings-model"));

    // cross-ref
    mappingModel.forEach(function (mapping) {
        var key = mapping.get("key");
        var projectModel = key && projectsModel.find(function(val) {
            return val.get("key") == key;
        });
        if (projectModel) {
            mapping.set({projectModel: projectModel});
        } else {
            mapping.set({projectModel: dontMapModel});
        }
    });

    mappingModel.forEach(function (mappingModel) {
        new SingleMappingView({
            model: mappingModel,
            projectsModel: projectsModel,
            canCreate: AJS.$("#projectMappings").data("create-projects"),
            el: "tr#" + mappingModel.id
        }).render();
    });

    AJS.$("#jimform").submit(function () {
        mappingModel.map(function (model) {
            if (model.get("projectModel").get("key") == DONT_MAP) {
                model.set("selected", false, {silent: true});
				model.unset("projectModel", {silent: true});
            }
            return model;
        });
        AJS.$("#projectMapping").val(JSON.stringify(mappingModel));
    });

    var updateNextButton = function() {
        var nextButtonEnabled = mappingModel.every(function (mapping) { return mapping.get("projectModel") != null; })
				&& mappingModel.any(function (mapping) { return mapping.get("projectModel").get("key") != DONT_MAP; });

        if (nextButtonEnabled) {
			AJS.$("#nextButton").removeAttr("disabled");
		} else {
			AJS.$("#nextButton").attr("disabled", "disabled");
		}
    };

    mappingModel.bind("change:selected", updateNextButton);
    mappingModel.bind("change:projectModel", updateNextButton);
    AJS.$(updateNextButton);
});
