AJS.$(function ($) {

	var FieldMappingRow = Backbone.View.extend({
		events: {
            "click .manual-mapping-checkbox": "manualMappingTicked"
        },

		initialize: function() {
			_.bindAll(this, "render", "manualMappingTicked", "customFieldsChanged", "renderSelectionDropdown", "submitCleanup", "selectField", "unselectField");
			this.fieldSelect = new importer.NextButtonAwareSingleSelect({
				element: this.$(".importField"),
				itemAttrDisplayed: "label",
				mappingModel: this.model
			});
			this.$(".importField")
                .bind("selected", this.selectField)
                .bind("unselect", this.unselectField); // bind later to avoid premature trigger in new above

			this.checkbox = this.$(".field-mapping-checkbox");
			this.manualMappingCheckbox = this.$(".manual-mapping-checkbox");
			this.additionalHintContainer = $(this.el).next(".additional-hint-container");
			this.additionalHintSection = $(this.el).next().find(".in-table-hint");
			this.fieldMappingWarning = this.$(".field-mapping-warning");

			this.model.bind('change', this.render);

            this.options.customFieldsModel.bind('change', this.customFieldsChanged);
			this.options.customFieldsModel.bind('add', this.customFieldsChanged);
			this.customFieldsChanged(); // initialize select contents

			$(this.el).parents("form").bind("submit", this.submitCleanup);
		},

		manualMappingTicked: function() {
			this.model.set({"manualMapping": !this.model.get("manualMapping")});
		},

		render: function() {
			var isImported = this.model.get("imported");
			var targetField = this.model.get("targetField");
			this.renderSelectionDropdown(targetField);

			if (targetField == "comment" && isImported) {
				this.additionalHintSection.html(AJS.I18n.getText('jira-importer-plugin.csv.field.mappings.page.comment.date.author'));
				this.additionalHintContainer.toggle(true);
			} else {
				this.additionalHintContainer.toggle(false);
			}

			setChecked(this.manualMappingCheckbox, this.model.get("manualMapping"));
//			this.manualMappingSection.toggle(this.model.get("manualMapping"));
			setEnablement(this.manualMappingCheckbox, isImported && targetField);
			this.fieldMappingWarning.toggle(isImported);
		},

		renderSelectionDropdown: function (targetField) {
			// targetField can be null, standard field name, custom field id or custom field model cid
            if (targetField == "newCustomField") {
				// handle the case when we get the initial data from a config file and it contains a mapping to a new custom field
				// done here because we don't have any id for the field to reference it by
				var data = this.model.get("customFieldModel");
				var newField = new Backbone.Model({name: data.name, type: data.type});
				this.options.customFieldsModel.add(newField);
				this.model.set({targetField: newField.cid, customFieldModel: newField}, {silent: true});
				this.fieldSelect.selectByKey(newField.cid);
            } else {
				var byId = this.options.customFieldsModel.get(targetField);
				var actualKey = byId ? byId.cid : targetField;
				var selectedDescriptor = this.fieldSelect.getSelectedDescriptor();
				var selectedKey = selectedDescriptor ? selectedDescriptor.value() : null;
				if (actualKey != selectedKey) {
					this.fieldSelect.selectByKey(actualKey);
                    if (!this.fieldSelect.getSelectedDescriptor()) {
                        this.fieldSelect.setSelection(this.fieldSelect.model.getDescriptor("jim-csv-field-disabled"));
                    }
				}
			}
			//this.fieldSelect.updateOverlabel();
		},

		customFieldsChanged: function() {
			var groupCustomFields = new AJS.GroupDescriptor({
				label: $("#fieldMappings").data("custom-fields-optgroup-title"),
				type: "optgroup",
				weight: 1,
				items: this.options.customFieldsModel.map(function (model) {
					return new AJS.ItemDescriptor({
						value: model.cid,
						label: model.get("name"),
						projectModel: model
					});
				})
			});

			this.fieldSelect.model.appendOptionsFromJSON([groupCustomFields]);
		},

		submitCleanup: function () {
			if (!this.fieldSelect.getSelectedDescriptor()) {
				this.model.unset("projectModel", {silent: true});
			}
		},

		unselectField: function () {
			this.model.set({targetField: null, customFieldModel: null});
		},

		selectField: function(evt) {
			var selectedDescriptor = this.fieldSelect.getSelectedDescriptor();
			var newTargetField = selectedDescriptor && selectedDescriptor.value();
            this.model.set({"imported": newTargetField !== "jim-csv-field-disabled"});

            if (newTargetField == "newCustomField") {
				var model = this.model, customFieldsModel = this.options.customFieldsModel;
				function setNewCustomFieldData(name, type) {
					var newCustomField = new Backbone.Model({
						name: name,
						type: type
					});
					customFieldsModel.add(newCustomField);
					model.set({targetField: newCustomField.cid, customFieldModel: newCustomField});
				}
				var byModel = this.model.get("customFieldModel");
				this.fieldSelect.selectByKey(byModel ? byModel.cid : this.model.get("targetField"));
				new JIRA.FormDialog({
					url: contextPath + "/secure/admin/AddCustomFieldDialog.jspa",
					ajaxOptions: { url: contextPath + "/secure/admin/AddCustomFieldDialog!default.jspa"},
					submitAjaxOptions: { url: contextPath + "/secure/admin/AddCustomFieldDialog.jspa"},
					onDialogFinished: function() {},
					onSuccessfulSubmit: function () {
						setNewCustomFieldData(
								this.$form.find("input[name=customFieldName]").val(),
								this.$form.find("select[name=customFieldType]").val()
						);
					},
					autoClose: true
				}).show();
			} else {
				var getByCid = (customFields.getByCid) ? customFields.getByCid : customFields.get; // 'getByCid' was removed in Backbone 0.9.9 in favor of just using 'get'
				var customField = getByCid.call(customFields, newTargetField); // null for standard fields
				var id = customField ? (customField.id || customField.cid) : newTargetField;
				this.model.set({targetField: id, customFieldModel: customField});
			}
		}

	});


	var MissingMappingsView = Backbone.View.extend({
		initialize: function() {
			_.bindAll(this, "render");
			this.model.bind('change', this.render);
		},

		render: function() {
			var summaryMapped = this.model.find(function(entry) {
				return entry.get("targetField") == "summary" && entry.get("imported");
			});

			var fieldImportedButNotMapped = this.model.find(function(entry) {
				return (!entry.get("targetField")) && entry.get("imported");
			});

			$(".missing-mapping.summary").toggle(!summaryMapped);
			setEnablement($("#nextButton"), summaryMapped != null && !fieldImportedButNotMapped);
		}

	});

	var InfoBoxesView = Backbone.View.extend({
		initialize: function() {
			_.bindAll(this, "render", "hasCommentsMapped");
			this.model.bind('change', this.render);
			this.infoSection = $(this.el);
		},

		render: function() {
			var messages = [
				AJS.I18n.getText('jira-importer-plugin.csv.field.mappings.page.multiple.fields'),
				AJS.I18n.getText('jira-import-plugin.csv.field.mappings.page.existing.custom.fields.warning')
			];

			if ($("#fieldMappings").data("subtasks-enabled")) {
				messages.push(AJS.I18n.getText('jira-importer-plugin.csv.mappings.subtasks.info', AJS.I18n.getText('jira-importer-plugin.csv.mappings.subtasks.issueid'),
						AJS.I18n.getText('jira-importer-plugin.csv.mappings.subtasks.parentid'), AJS.I18n.getText('issue.field.issuetype')));
			}

			if ($("#fieldMappings").data("empty-headers")) {
				messages.push(AJS.I18n.getText('jira-importer-plugin.csv.field.mappings.page.empty.header'));
			}

            if ($("#fieldMappings").data("reading-projects")) {
                messages.push(AJS.I18n.getText('jira-importer-plugin.csv.mappings.projects.info', AJS.I18n.getText('jira-importer-plugin.csv.mappings.projects.projectkey'),
                        AJS.I18n.getText('jira-importer-plugin.csv.mappings.projects.projectname')));
            }

            var issueKeyMapped = this.model.find(function(entry) {
                return entry.get("targetField") == "issuekey" && entry.get("imported");
            });

            $(".issue-mapping.issuekey").toggle(!!issueKeyMapped);

			if (messages.length > 0) {
				var message = "";
				_.forEach(messages, function(entry) {
					message += ("<div class='hint'>" + entry + "</div>");
				});
				this.infoSection.html(message);
			}
			this.infoSection.toggle(messages.length != 0);
		},

		hasCommentsMapped: function() {
			var commentMapped = this.model.find(function(entry) {
				return entry.get("targetField") == "comment" && entry.get("imported");
			});
			return commentMapped != null;
		}

	});


	function setChecked(checkbox, state)  {
		if (state) {
			checkbox.attr('checked', 'checked');
		} else {
			checkbox.removeAttr('checked');
		}
	}

	function setEnablement(jqueryObject, state) {
		if (state) {
			jqueryObject.removeAttr("disabled");
		} else {
			jqueryObject.attr("disabled", "disabled");
		}
	}

	var customFields = new Backbone.Collection().reset($.parseJSON($("#fieldMappings").data("custom-fields-model")));
    var models = new Backbone.Collection().reset($.parseJSON($("#fieldMappings").data("mappings-model")));
	models.each(function(mappingRow) {
		new FieldMappingRow({ id: mappingRow.id, model: mappingRow, el: "#" + mappingRow.id, customFieldsModel: customFields}).render();
	});

	$("#jimform").submit(function () {
		$("#model").val(JSON.stringify(models));
	});

    var nextButtonHintsView = new MissingMappingsView({model: models, el: "#nextButtonHints"});
    nextButtonHintsView.render();
    new InfoBoxesView({model: models, el: ".bottom-wizard-hints"}).render();

	var fillToolTip = function (contents, trigger, showPopup) {
		contents.html($("#duplicate-column-message").html());
		contents.css("background", "#FFFFDD");
		contents.   parent().find("#arrow-duplicate-column-info path").attr("fill", "#FFFFDD");
		showPopup();
	};
	AJS.InlineDialog($(".duplicate-column-info"), "duplicate-column-info", fillToolTip, {width: 450, onHover: true, onTop: true, hideDelay: 0});
	$("option[value='newCustomField']").css("font-style", "italic");

});
