AJS.$(function () {
    var showState = function() {
        function handleValidationRunning(data) {
            var stage = data.stages.ISSUES;
            var progress = Math.round((stage.itemsImported * 100) / stage.itemsToBeImported);
            progress = isNaN(progress) ? 0 : progress;
            AJS.$("#progressPercent").text(progress);
            AJS.progressBars.update("#validation-pb", progress/100);
        }

        function hideProgressElements() {
            AJS.$("#cancelButton").hide();
            AJS.$("#progressPercent").text("100");
            AJS.$("#waitProgress").hide();
            AJS.$("#nextButton").show();
        }

        var warningCount = 0;
        var errorCount = 0;
        function addNewMessages(data) {
            var stage = data.stages.ISSUES;
            if (data.warnings.length > warningCount) {
                warningCount = data.warnings.length;
                fillMessages('#warningsMessage', data.warnings);
                AJS.$('.warn-issue').text(stage.itemsCreatedWithWarnings);
            }
            if (data.failures.length > errorCount) {
                errorCount = data.failures.length;
                fillMessages('#errorsMessage', data.failures);
                AJS.$('.err-issue').text(stage.itemsToBeImported - stage.itemsCreated);
            }
            AJS.$('.ok-issue').text(stage.itemsCreated - stage.itemsCreatedWithWarnings);
            hideTooManyMessages();
        }

        function fillMessages(msgId, messages) {
            AJS.$(msgId).removeClass('hidden-message');
            AJS.$(msgId + " > p > strong > span").text(messages.length);
            AJS.$(msgId + " > ul").empty();
            for (var i in messages) {
                AJS.$(msgId + " > ul").append(AJS.$("<li>").text(messages[i]));
                if (i > 100) {
                    break;
                }
            }
        }

        function hideTooManyMessages() {
            AJS.$(["ul.warnings", "ul.failures"]).each(function(idx, ctx) {
                if (AJS.$("li", ctx).size() > 5) {
                    AJS.$("li:gt(4)", ctx).hide();
                    AJS.$("li:eq(4)", ctx).after("<li class='show-more'><a href='#'>Show more</a></li>");
                }
            });

            AJS.$('li.show-more a').click(function(event) {
                AJS.$("li:gt(4)", AJS.$(this).parent().parent()).toggle();
                event.preventDefault();
            });
        }

        AJS.$.ajax({
            url: contextPath + "/rest/jira-importers-plugin/1.0/importer/com.atlassian.jira.plugins.jira-importers-plugin:bulkCreateCsv/status",
            cache: false,
            data: { },
            success: function(data, textStatus, jqXHR) {
                if (!data.aborted && data.running) {
                    handleValidationRunning(data);
                    addNewMessages(data)
                } else {
                    hideProgressElements();
                    addNewMessages(data);

                    if (data.aborted == true) {
                        AJS.$("#message-aborted").removeClass('hidden-message');
                    } else {
                        if (warningCount > 0 || errorCount > 0) {
                            AJS.$("#validation-message-error").removeClass('hidden-message');
                        } else {
                            AJS.$("#validation-message-ok").removeClass('hidden-message');
                        }
                    }
                    clearInterval(intervalId);
                }
            }
        });
    };

    var intervalId = setInterval(showState, 1000);

    AJS.$(document).ready(function() {
        AJS.progressBars.setIndeterminate("#validation-pb");
        AJS.$("#nextButton").hide();
        AJS.$("#cancelButton").click(function(event) {
            event.preventDefault();
            AJS.$.post(
                    contextPath + "/rest/jira-importers-plugin/1.0/importer/com.atlassian.jira.plugins.jira-importers-plugin:bulkCreateCsv/abort");
        });
    });

    AJS.$(["ul.warnings", "ul.failures"]).each(function(idx, ctx) {
        if (AJS.$("li", ctx).size() > 5) {
            AJS.$("li:gt(4)", ctx).hide();
            AJS.$("li:eq(4)", ctx).after("<li class='show-more'><a href='#'>Show more</a></li>");
        }
    });

    AJS.$('li.show-more a').click(function(event) {
        AJS.$("li:gt(4)", AJS.$(this).parent().parent()).toggle();
        event.preventDefault();
    });
});