/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.web.impl;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugins.importer.analytics.WizardConfigFileUsedEvent;
import com.atlassian.jira.plugins.importer.extensions.ImporterController;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean;
import com.atlassian.jira.plugins.importer.web.AbstractSetupPage;
import com.atlassian.jira.plugins.importer.web.ConfigFileHandler;
import com.atlassian.jira.util.AttachmentUtils;
import com.atlassian.jira.web.util.AttachmentException;
import com.atlassian.jira.web.util.WebAttachmentManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.File;
import org.codehaus.jackson.JsonParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import webwork.multipart.MultiPartRequestWrapper;

@Component
@ExportAsService
public class DefaultConfigFileHandler
implements ConfigFileHandler {
    public static final String CONFIG_FILE_INPUT_NAME = "configFile";
    private final WebAttachmentManager webAttachmentManager;

    @Autowired
    public DefaultConfigFileHandler(@ComponentImport WebAttachmentManager webAttachmentManager) {
        this.webAttachmentManager = webAttachmentManager;
    }

    @Override
    public boolean verifyConfigFileParam(AbstractSetupPage setupPage) {
        try {
            AttachmentUtils.checkValidTemporaryAttachmentDirectory();
        }
        catch (AttachmentException e) {
            setupPage.addError(CONFIG_FILE_INPUT_NAME, e.getMessage());
            return false;
        }
        MultiPartRequestWrapper multipart = setupPage.getMultipart();
        if (multipart != null) {
            try {
                this.webAttachmentManager.validateAttachmentIfExists(multipart, CONFIG_FILE_INPUT_NAME, false);
            }
            catch (AttachmentException e) {
                setupPage.addError(CONFIG_FILE_INPUT_NAME, e.getMessage());
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean populateFromConfigFile(AbstractSetupPage setupPage, AbstractConfigBean configBean) {
        File configFile = setupPage.getMultipart().getFile(CONFIG_FILE_INPUT_NAME);
        if (configFile != null) {
            try {
                configBean.copyFromProperties(configFile);
                this.triggerAnalyticsEvent(setupPage);
            }
            catch (Exception e) {
                if (e instanceof JsonParseException) {
                    setupPage.addErrorMessage(setupPage.getText("jira-importer-plugin.import.setup.page.config.file.format.changed"));
                }
                setupPage.addError(CONFIG_FILE_INPUT_NAME, e.getMessage());
                return false;
            }
        }
        return true;
    }

    private void triggerAnalyticsEvent(AbstractSetupPage setupPage) {
        EventPublisher eventPublisher = (EventPublisher)ComponentAccessor.getComponent(EventPublisher.class);
        ImporterController controller = setupPage.getController();
        if (eventPublisher == null || controller == null) {
            return;
        }
        eventPublisher.publish((Object)new WizardConfigFileUsedEvent(controller.getId()));
    }
}

